/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.Reorder;

public class WekaMultiLabelSplitter
extends AbstractTransformer {
    private static final long serialVersionUID = 4034797930137217038L;
    public static final String BACKUP_CLASSATTRIBUTES = "class attributes";
    public static final String BACKUP_ATTRIBUTESTOPROCESS = "attributes to process";
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;
    protected boolean m_UpdateRelationName;
    protected boolean m_MakeClassLast;
    protected Vector<Integer> m_ClassAttributes;
    protected Vector<Integer> m_AttributesToProcess;
    protected Instances m_Dataset;

    public String globalInfo() {
        return "Splits a dataset containing multiple class attributes ('multi-label') into separate datasets with only a single class attribute.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", (Object)false);
        this.m_OptionManager.add("update", "updateRelationName", (Object)false);
        this.m_OptionManager.add("make-class-last", "makeClassLast", (Object)false);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)(this.m_Invert ? "! " : ""));
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the strings.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    public void setUpdateRelationName(boolean value) {
        this.m_UpdateRelationName = value;
        this.reset();
    }

    public boolean getUpdateRelationName() {
        return this.m_UpdateRelationName;
    }

    public String updateRelationNameTipText() {
        return "If set to true, then the name of the class attribute is used as new relation name.";
    }

    public void setMakeClassLast(boolean value) {
        this.m_MakeClassLast = value;
        this.reset();
    }

    public boolean getMakeClassLast() {
        return this.m_MakeClassLast;
    }

    public String makeClassLastTipText() {
        return "If set to true, then the new class attribute will be moved to the end.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLASSATTRIBUTES);
        this.pruneBackup(BACKUP_ATTRIBUTESTOPROCESS);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ClassAttributes != null) {
            result.put(BACKUP_CLASSATTRIBUTES, this.m_ClassAttributes);
        }
        if (this.m_AttributesToProcess != null) {
            result.put(BACKUP_ATTRIBUTESTOPROCESS, this.m_AttributesToProcess);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLASSATTRIBUTES)) {
            this.m_ClassAttributes = (Vector)state.get(BACKUP_CLASSATTRIBUTES);
            state.remove(BACKUP_CLASSATTRIBUTES);
        }
        if (state.containsKey(BACKUP_ATTRIBUTESTOPROCESS)) {
            this.m_AttributesToProcess = (Vector)state.get(BACKUP_ATTRIBUTESTOPROCESS);
            state.remove(BACKUP_ATTRIBUTESTOPROCESS);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_ClassAttributes = new Vector();
        this.m_AttributesToProcess = new Vector();
    }

    protected String doExecute() {
        String result = null;
        this.m_Dataset = (Instances)this.m_InputToken.getPayload();
        for (int i = 0; i < this.m_Dataset.numAttributes(); ++i) {
            if (this.m_Invert) {
                if (this.m_RegExp.isMatch(this.m_Dataset.attribute(i).name())) continue;
                this.m_ClassAttributes.add(i);
                continue;
            }
            if (!this.m_RegExp.isMatch(this.m_Dataset.attribute(i).name())) continue;
            this.m_ClassAttributes.add(i);
        }
        if (this.m_ClassAttributes.size() == 0) {
            result = "No attribute names matched the " + (this.m_Invert ? "inverted" : "") + " regular expression: " + this.m_RegExp;
        } else {
            this.m_AttributesToProcess.addAll(this.m_ClassAttributes);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_AttributesToProcess.size() > 0;
    }

    public Token output() {
        Instances processed;
        int i;
        Token result = null;
        int index = this.m_AttributesToProcess.remove(0);
        Remove remove = new Remove();
        StringBuilder indices = new StringBuilder();
        for (i = 0; i < this.m_ClassAttributes.size(); ++i) {
            if (this.m_ClassAttributes.get(i) == index) continue;
            if (indices.length() > 0) {
                indices.append(",");
            }
            indices.append("" + (this.m_ClassAttributes.get(i) + 1));
        }
        remove.setAttributeIndices(indices.toString());
        try {
            remove.setInputFormat(this.m_Dataset);
            processed = Filter.useFilter((Instances)this.m_Dataset, (Filter)remove);
            if (this.m_UpdateRelationName) {
                processed.setRelationName(this.m_Dataset.attribute(index).name());
            }
            result = new Token((Object)processed);
        }
        catch (Exception e) {
            processed = null;
            this.handleException("Failed to process dataset with following filter setup:\n" + OptionUtils.getCommandLine((Object)remove), e);
        }
        if (this.m_MakeClassLast && processed != null) {
            int newIndex = processed.attribute(this.m_Dataset.attribute(index).name()).index();
            indices = new StringBuilder();
            for (i = 0; i < processed.numAttributes(); ++i) {
                if (i == newIndex) continue;
                if (indices.length() > 0) {
                    indices.append(",");
                }
                indices.append("" + (i + 1));
            }
            if (indices.length() > 0) {
                indices.append(",");
            }
            indices.append("" + (newIndex + 1));
            Reorder reorder = new Reorder();
            try {
                reorder.setAttributeIndices(indices.toString());
                reorder.setInputFormat(processed);
                processed = Filter.useFilter((Instances)processed, (Filter)reorder);
                if (this.m_UpdateRelationName) {
                    processed.setRelationName(this.m_Dataset.attribute(index).name());
                }
                result = new Token((Object)processed);
            }
            catch (Exception e) {
                this.handleException("Failed to process dataset with following filter setup:\n" + OptionUtils.getCommandLine((Object)reorder), e);
            }
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_AttributesToProcess != null) {
            this.m_AttributesToProcess.clear();
        }
        if (this.m_ClassAttributes != null) {
            this.m_ClassAttributes.clear();
        }
        this.m_Dataset = null;
        super.wrapUp();
    }
}

