/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.WekaClustererSetup;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.wekaclusterer.AbstractClustererPostProcessor;
import adams.flow.transformer.wekaclusterer.PassThrough;
import java.util.Hashtable;
import weka.clusterers.Clusterer;
import weka.clusterers.UpdateableClusterer;
import weka.core.Instance;
import weka.core.Instances;

public class WekaTrainClusterer
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    public static final String BACKUP_INCREMENTALCLUSTERER = "incremental clusterer";
    protected GlobalActorReference m_Clusterer;
    protected Clusterer m_ActualClusterer;
    protected Clusterer m_IncrementalClusterer;
    protected AbstractClustererPostProcessor m_PostProcessor;

    public String globalInfo() {
        return "Trains a clusterer based on the incoming dataset and output the built clusterer alongside the training header (in a model container).\nIncremental training is performed, if the input are weka.core.Instance objects and the clusterer implements " + UpdateableClusterer.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("clusterer", "clusterer", (Object)new GlobalActorReference(WekaClustererSetup.class.getSimpleName()));
        this.m_OptionManager.add("post-processor", "postProcessor", (Object)new PassThrough());
    }

    public void setClusterer(GlobalActorReference value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public GlobalActorReference getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The Weka clusterer to build on the input data.";
    }

    public void setPostProcessor(AbstractClustererPostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractClustererPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to use on model containers.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"clusterer", (Object)this.m_Clusterer);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"postProcessor", (Object)((Object)(this.m_PostProcessor instanceof PassThrough ? this.m_PostProcessor : null)), (String)", post-processor: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INCREMENTALCLUSTERER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_IncrementalClusterer != null) {
            result.put(BACKUP_INCREMENTALCLUSTERER, this.m_IncrementalClusterer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INCREMENTALCLUSTERER)) {
            this.m_IncrementalClusterer = (Clusterer)state.get(BACKUP_INCREMENTALCLUSTERER);
            state.remove(BACKUP_INCREMENTALCLUSTERER);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_IncrementalClusterer = null;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected Clusterer getClustererInstance() {
        return (Clusterer)GlobalActorHelper.getSetup(Clusterer.class, (GlobalActorReference)this.m_Clusterer, (AbstractActor)this);
    }

    protected String doExecute() {
        String result = null;
        try {
            Clusterer cls = null;
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                cls = this.getClustererInstance();
                Instances data = (Instances)this.m_InputToken.getPayload();
                cls.buildClusterer(data);
                WekaModelContainer cont = new WekaModelContainer(cls, new Instances(data, 0), data);
                cont = this.m_PostProcessor.postProcess(cont);
                this.m_OutputToken = new Token((Object)cont);
            } else if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                if (this.m_IncrementalClusterer == null && !((cls = this.getClustererInstance()) instanceof UpdateableClusterer)) {
                    result = cls.getClass().getName() + " is not an incremental clusterer!";
                }
                if (result == null) {
                    Instance inst = (Instance)this.m_InputToken.getPayload();
                    if (this.m_IncrementalClusterer == null) {
                        this.m_IncrementalClusterer = cls;
                        Instances data = new Instances(inst.dataset(), 1);
                        data.add((Instance)inst.copy());
                        this.m_IncrementalClusterer.buildClusterer(data);
                    } else {
                        ((UpdateableClusterer)this.m_IncrementalClusterer).updateClusterer(inst);
                        ((UpdateableClusterer)this.m_IncrementalClusterer).updateFinished();
                    }
                    this.m_OutputToken = new Token((Object)new WekaModelContainer(this.m_IncrementalClusterer, new Instances(inst.dataset(), 0)));
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process input: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.MODEL_GENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

