/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.flow.container.WekaTrainTestSetContainer;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import weka.core.Instances;

public abstract class AbstractSplitGenerator
implements Serializable,
Iterator<WekaTrainTestSetContainer> {
    private static final long serialVersionUID = -8387205583429213079L;
    protected long m_Seed;
    protected Random m_Random;
    protected Instances m_Data;
    protected boolean m_Initialized;

    public AbstractSplitGenerator(Instances data, long seed) {
        if (data == null) {
            throw new IllegalArgumentException("No data provided!");
        }
        this.m_Data = new Instances(data);
        this.m_Seed = seed;
        this.m_Initialized = false;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    protected abstract boolean canRandomize();

    protected abstract boolean checkNext();

    @Override
    public synchronized boolean hasNext() {
        return this.checkNext();
    }

    protected void initialize() {
        this.m_Initialized = true;
        if (this.canRandomize()) {
            this.m_Random = new Random(this.m_Seed);
            this.m_Data.randomize(this.m_Random);
        }
    }

    protected abstract WekaTrainTestSetContainer createNext();

    @Override
    public synchronized WekaTrainTestSetContainer next() {
        if (!this.m_Initialized) {
            this.initialize();
        }
        return this.createNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not implemented!");
    }

    public String toString() {
        return "data=" + this.m_Data.relationName() + (this.canRandomize() ? ", seed=" + this.m_Seed : "");
    }
}

