/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SingleIndex;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class MergeTwoAttributes
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -8596728919861340618L;
    public static final int VALUESDIFFER_MISSING = 0;
    public static final int VALUESDIFFER_AVERAGE = 1;
    public static final int VALUESDIFFER_FIRST = 2;
    public static final int VALUESDIFFER_SECOND = 3;
    public static final Tag[] TAGS_VALUESDIFFER = new Tag[]{new Tag(0, "MISSING", "Set to missing"), new Tag(1, "AVERAGE", "Take average (numeric only)"), new Tag(2, "FIRST", "Use value from 1st attribute"), new Tag(3, "SECOND", "Use value from 2nd attribute")};
    public static final int ONEMISSING_MISSING = 0;
    public static final int ONEMISSING_USE_PRESENT = 1;
    public static final Tag[] TAGS_ONEMISSING = new Tag[]{new Tag(0, "MISSING", "Set to missing"), new Tag(1, "PRESENT", "Use present value")};
    public static final String DEFAULT_REMOVE_CHARS = " -_.";
    public static final String DEFAULT_NAME_FIRST = "att1";
    public static final String DEFAULT_NAME_SECOND = "att2";
    protected String m_FirstAttribute = "att1";
    protected String m_SecondAttribute = "att2";
    protected int m_Differ = 0;
    protected int m_OneMissing = 0;
    protected String m_RemoveChars = " -_.";
    protected SingleIndex m_MergedIndex = new SingleIndex("");
    protected String m_Merged;

    public String globalInfo() {
        return "Merges two attributes, offers various strategies if values differ or not present.\nUses the common subsequence (either from start or end) of the two attributes as name of the merged attribute, otherwise the concatenation of the both (separated by '-'). If this new name should already be present, then a number is appended to the name to make it unique.\nThe merged attribute can either be left at the default position (either first or second attribute, whichever comes first) or moved to a specific one.\nIf one of the two attributes to be merged is the current class attribute, the newly created merged attribute will become the new class attribute.";
    }

    public Enumeration listOptions() {
        SelectedTag tag;
        int i;
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe name of the first attribute.\n\t(default: att1)", "first", 1, "-first <att name>"));
        result.addElement(new Option("\tThe name of the second attribute.\n\t(default: att2)", "second", 1, "-second <att name>"));
        result.addElement(new Option("\tThe characters to remove from the start/end of the\n\tgenerated name for the merged attribute.\n\t(default:  -_.)", "remove-chars", 1, "-remove-chars <chars>"));
        result.addElement(new Option("\tThe new position for the merged attribute.\n\tEmpty string is default position, i.e., either the position\n\tof the first or second attribute (whichever comes first)\n\t(default: )", "merged-index", 1, "-merged-index <position>"));
        String param = "";
        for (i = 0; i < TAGS_VALUESDIFFER.length; ++i) {
            if (i > 0) {
                param = param + "|";
            }
            tag = new SelectedTag(TAGS_VALUESDIFFER[i].getID(), TAGS_VALUESDIFFER);
            param = param + tag.getSelectedTag().getIDStr();
        }
        result.addElement(new Option("\tThe strategy to apply in case the values of the two attributes differ.\n\t(default: " + new SelectedTag(0, TAGS_VALUESDIFFER) + ")", "differ", 1, "-differ <" + param + ">"));
        param = "";
        for (i = 0; i < TAGS_ONEMISSING.length; ++i) {
            if (i > 0) {
                param = param + "|";
            }
            tag = new SelectedTag(TAGS_ONEMISSING[i].getID(), TAGS_ONEMISSING);
            param = param + tag.getSelectedTag().getIDStr();
        }
        result.addElement(new Option("\tThe strategy to apply in case one of the two values is missing.\n\t(default: " + new SelectedTag(0, TAGS_ONEMISSING) + ")", "one-missing", 1, "-one-missing <" + param + ">"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-first");
        result.add("" + this.getFirstAttribute());
        result.add("-second");
        result.add("" + this.getSecondAttribute());
        if (this.getMergedIndex().length() > 0) {
            result.add("-merged-index");
            result.add("" + this.getMergedIndex());
        }
        result.add("-remove-chars");
        result.add("" + this.getRemoveChars());
        result.add("-differ");
        result.add("" + this.getDiffer().getSelectedTag().getIDStr());
        result.add("-one-missing");
        result.add("" + this.getOneMissing().getSelectedTag().getIDStr());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((String)"first", (String[])options);
        if (tmpStr.length() != 0) {
            this.setFirstAttribute(tmpStr);
        } else {
            this.setFirstAttribute(DEFAULT_NAME_FIRST);
        }
        tmpStr = Utils.getOption((String)"second", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSecondAttribute(tmpStr);
        } else {
            this.setSecondAttribute(DEFAULT_NAME_SECOND);
        }
        tmpStr = Utils.getOption((String)"merged-index", (String[])options);
        this.setMergedIndex(tmpStr);
        tmpStr = Utils.getOption((String)"remove-chars", (String[])options);
        if (tmpStr.length() != 0) {
            this.setRemoveChars(tmpStr);
        } else {
            this.setRemoveChars(DEFAULT_REMOVE_CHARS);
        }
        tmpStr = Utils.getOption((String)"differ", (String[])options);
        if (tmpStr.length() != 0) {
            this.setDiffer(new SelectedTag(tmpStr, TAGS_VALUESDIFFER));
        } else {
            this.setDiffer(new SelectedTag(0, TAGS_VALUESDIFFER));
        }
        tmpStr = Utils.getOption((String)"one-missing", (String[])options);
        if (tmpStr.length() != 0) {
            this.setOneMissing(new SelectedTag(tmpStr, TAGS_ONEMISSING));
        } else {
            this.setOneMissing(new SelectedTag(0, TAGS_ONEMISSING));
        }
    }

    public void setFirstAttribute(String value) {
        this.m_FirstAttribute = value;
    }

    public String getFirstAttribute() {
        return this.m_FirstAttribute;
    }

    public String firstAttributeTipText() {
        return "The name of the first attribute to merge.";
    }

    public void setSecondAttribute(String value) {
        this.m_SecondAttribute = value;
    }

    public String getSecondAttribute() {
        return this.m_SecondAttribute;
    }

    public String secondAttributeTipText() {
        return "The name of the second attribute to merge.";
    }

    public void setMergedIndex(String value) {
        this.m_MergedIndex.setSingleIndex(value);
    }

    public String getMergedIndex() {
        return this.m_MergedIndex.getSingleIndex();
    }

    public String mergedIndexTipText() {
        return "The new index of the merged attribute, leave empty for default position; 'first' and 'last' are accepted as well.";
    }

    public void setRemoveChars(String value) {
        this.m_RemoveChars = value;
    }

    public String getRemoveChars() {
        return this.m_RemoveChars;
    }

    public String removeCharsTipText() {
        return "The characters to remove from the start/end of the generated name for the merged attribute.";
    }

    public void setDiffer(SelectedTag value) {
        if (value.getTags() == TAGS_VALUESDIFFER) {
            this.m_Differ = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getDiffer() {
        return new SelectedTag(this.m_Differ, TAGS_VALUESDIFFER);
    }

    public String differTipText() {
        return "The strategy to apply if the two values differ.";
    }

    public void setOneMissing(SelectedTag value) {
        if (value.getTags() == TAGS_ONEMISSING) {
            this.m_OneMissing = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getOneMissing() {
        return new SelectedTag(this.m_OneMissing, TAGS_ONEMISSING);
    }

    public String oneMissingTipText() {
        return "Sets the strategy to apply if one of the values is missing.";
    }

    protected String commonSubsequence(String s1, String s2, boolean forward) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < Math.min(s1.length(), s2.length()); ++i) {
            if (forward) {
                if (s1.charAt(i) != s2.charAt(i)) break;
                result.append(s1.charAt(i));
                continue;
            }
            if (s1.charAt(s1.length() - i - 1) != s2.charAt(s2.length() - i - 1)) break;
            result.insert(0, s1.charAt(s1.length() - i - 1));
        }
        if (this.m_RemoveChars.length() > 0) {
            while (result.length() > 0 && this.m_RemoveChars.indexOf(result.charAt(0)) > -1) {
                result.delete(0, 1);
            }
            while (result.length() > 0 && this.m_RemoveChars.indexOf(result.charAt(result.length() - 1)) > -1) {
                result.delete(result.length() - 1, result.length());
            }
        }
        return result.toString();
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Attribute newAtt;
        if (inputFormat.attribute(this.m_FirstAttribute) == null) {
            throw new WekaException("First attribute '" + this.m_FirstAttribute + "' not found!");
        }
        if (inputFormat.attribute(this.m_SecondAttribute) == null) {
            throw new WekaException("Second attribute '" + this.m_SecondAttribute + "' not found!");
        }
        String common = this.commonSubsequence(this.m_FirstAttribute, this.m_SecondAttribute, true);
        if (common.length() == 0) {
            common = this.commonSubsequence(this.m_FirstAttribute, this.m_SecondAttribute, false);
        }
        if (common.length() == 0) {
            common = this.m_FirstAttribute + "-" + this.m_SecondAttribute;
        }
        this.m_Merged = common;
        int i = 1;
        while (inputFormat.attribute(this.m_Merged) != null) {
            this.m_Merged = common + "-" + ++i;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        Attribute oldAtt1 = inputFormat.attribute(this.m_FirstAttribute);
        Attribute oldAtt2 = inputFormat.attribute(this.m_SecondAttribute);
        boolean done = false;
        int current = -1;
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            Attribute oldAtt = inputFormat.attribute(i);
            if (oldAtt.name().equals(this.m_FirstAttribute) || oldAtt.name().equals(this.m_SecondAttribute)) {
                if (done) continue;
                switch (oldAtt.type()) {
                    case 0: {
                        newAtt = new Attribute(this.m_Merged);
                        done = true;
                        break;
                    }
                    case 1: {
                        HashSet<String> labels = new HashSet<String>();
                        Enumeration enm = oldAtt1.enumerateValues();
                        while (enm.hasMoreElements()) {
                            labels.add(enm.nextElement().toString());
                        }
                        enm = oldAtt2.enumerateValues();
                        while (enm.hasMoreElements()) {
                            labels.add(enm.nextElement().toString());
                        }
                        ArrayList values = new ArrayList(labels);
                        Collections.sort(values);
                        newAtt = new Attribute(this.m_Merged, values);
                        done = true;
                        break;
                    }
                    case 2: {
                        newAtt = new Attribute(this.m_Merged, (List)null);
                        done = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot merged attributes of type " + Attribute.typeToString((Attribute)oldAtt));
                    }
                }
                current = atts.size();
                atts.add(newAtt);
                continue;
            }
            newAtt = (Attribute)oldAtt.copy();
            atts.add(newAtt);
        }
        if (this.m_MergedIndex.getSingleIndex().length() > 0 && current > -1) {
            this.m_MergedIndex.setUpper(atts.size() - 1);
            newAtt = (Attribute)atts.remove(current);
            atts.add(this.m_MergedIndex.getIndex(), newAtt);
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (inputFormat.classIndex() > -1) {
            if (result.attribute(inputFormat.classAttribute().name()) != null) {
                result.setClass(result.attribute(inputFormat.classAttribute().name()));
            } else {
                result.setClass(result.attribute(this.m_Merged));
            }
        }
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = this.getOutputFormat();
        int indexAtt1 = instances.attribute(this.m_FirstAttribute).index();
        int indexAtt2 = instances.attribute(this.m_SecondAttribute).index();
        int indexMerged = result.attribute(this.m_Merged).index();
        boolean isNumeric = result.attribute(indexMerged).isNumeric();
        boolean isString = result.attribute(indexMerged).isString();
        for (int i = 0; i < instances.numInstances(); ++i) {
            double[] valuesNew;
            double[] valuesOld;
            Instance instOld;
            block15: {
                block16: {
                    block14: {
                        instOld = instances.instance(i);
                        valuesOld = instOld.toDoubleArray();
                        valuesNew = new double[result.numAttributes()];
                        if (!Utils.isMissingValue((double)valuesOld[indexAtt1]) && !Utils.isMissingValue((double)valuesOld[indexAtt2])) break block14;
                        switch (this.m_OneMissing) {
                            case 0: {
                                valuesNew[indexMerged] = Utils.missingValue();
                                break block15;
                            }
                            case 1: {
                                valuesNew[indexMerged] = Utils.isMissingValue((double)valuesOld[indexAtt1]) && Utils.isMissingValue((double)valuesOld[indexAtt2]) ? Utils.missingValue() : (Utils.isMissingValue((double)valuesOld[indexAtt1]) ? (isNumeric ? valuesOld[indexAtt2] : (isString ? (double)result.attribute(indexMerged).addStringValue(instOld.stringValue(indexAtt2)) : (double)result.attribute(indexMerged).indexOfValue(instOld.stringValue(indexAtt2)))) : (isNumeric ? valuesOld[indexAtt1] : (isString ? (double)result.attribute(indexMerged).addStringValue(instOld.stringValue(indexAtt1)) : (double)result.attribute(indexMerged).indexOfValue(instOld.stringValue(indexAtt1)))));
                                break block15;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled type (oneMissing): " + this.m_OneMissing);
                            }
                        }
                    }
                    if ((!isNumeric || valuesOld[indexAtt1] == valuesOld[indexAtt2]) && (isNumeric || instOld.stringValue(indexAtt1).equals(instOld.stringValue(indexAtt2)))) break block16;
                    switch (this.m_Differ) {
                        case 0: {
                            valuesNew[indexMerged] = Utils.missingValue();
                            break block15;
                        }
                        case 1: {
                            valuesNew[indexMerged] = isNumeric ? (valuesOld[indexAtt1] + valuesOld[indexAtt2]) / 2.0 : Utils.missingValue();
                            break block15;
                        }
                        case 2: {
                            valuesNew[indexMerged] = isNumeric ? valuesOld[indexAtt1] : (isString ? (double)result.attribute(indexMerged).addStringValue(instOld.stringValue(indexAtt1)) : (double)result.attribute(indexMerged).indexOfValue(instOld.stringValue(indexAtt1)));
                            break block15;
                        }
                        case 3: {
                            valuesNew[indexMerged] = isNumeric ? valuesOld[indexAtt2] : (isString ? (double)result.attribute(indexMerged).addStringValue(instOld.stringValue(indexAtt2)) : (double)result.attribute(indexMerged).indexOfValue(instOld.stringValue(indexAtt2)));
                            break block15;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled type (differ): " + this.m_Differ);
                        }
                    }
                }
                valuesNew[indexMerged] = isNumeric ? valuesOld[indexAtt1] : (isString ? (double)result.attribute(indexMerged).addStringValue(instOld.stringValue(indexAtt1)) : (double)result.attribute(indexMerged).indexOfValue(instOld.stringValue(indexAtt1)));
            }
            int indexOld = 0;
            int indexNew = 0;
            while (indexOld < instOld.numAttributes()) {
                if (indexOld == indexAtt1 || indexOld == indexAtt2) {
                    ++indexOld;
                    continue;
                }
                if (indexNew == indexMerged) {
                    ++indexNew;
                    continue;
                }
                valuesNew[indexNew] = Utils.isMissingValue((double)valuesOld[indexOld]) ? valuesOld[indexOld] : (result.attribute(indexNew).isString() ? (double)result.attribute(indexNew).addStringValue(instOld.stringValue(indexOld)) : valuesOld[indexOld]);
                ++indexNew;
                ++indexOld;
            }
            DenseInstance instNew = new DenseInstance(instOld.weight(), valuesNew);
            result.add((Instance)instNew);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 6874 $");
    }

    public static void main(String[] args) {
        MergeTwoAttributes.runFilter((Filter)new MergeTwoAttributes(), (String[])args);
    }
}

