/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.util.ArrayList;
import java.util.Hashtable;
import weka.gui.explorer.AbstractExplorerPanelHandler;
import weka.gui.explorer.AttributeSelectionPanel;
import weka.gui.explorer.Explorer;

public class AttributeSelectionHandler
extends AbstractExplorerPanelHandler {
    private static final long serialVersionUID = 2284676357783882049L;
    public static final String KEY_TEST = "test";
    public static final String KEY_CV_FOLDS = "cv-folds";
    public static final String KEY_RANDOM_SEED = "random seed";
    public static final String KEY_CLASS_INDEX = "class index";
    public static final String VALUE_CROSS_VALIDATION = "cross-validation";
    public static final String VALUE_TRAINING_SET = "training set";

    @Override
    public boolean handles(Explorer.ExplorerPanel panel) {
        return panel instanceof AttributeSelectionPanel;
    }

    @Override
    public Object serialize(Explorer.ExplorerPanel panel) {
        AttributeSelectionPanel pnl = (AttributeSelectionPanel)panel;
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.serialize(pnl.m_AttributeEvaluatorEditor));
        result.add(this.serialize(pnl.m_AttributeSearchEditor));
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        if (pnl.m_TrainBut.isSelected()) {
            options.put(KEY_TEST, VALUE_TRAINING_SET);
        } else if (pnl.m_CVBut.isSelected()) {
            options.put(KEY_TEST, VALUE_CROSS_VALIDATION);
        }
        options.put(KEY_CV_FOLDS, pnl.m_CVText.getText());
        options.put(KEY_RANDOM_SEED, pnl.m_SeedText.getText());
        options.put(KEY_CLASS_INDEX, pnl.m_ClassCombo.getSelectedIndex());
        result.add(options);
        result.add(this.serialize(pnl.m_History));
        return result;
    }

    @Override
    public void deserialize(Explorer.ExplorerPanel panel, Object data) {
        AttributeSelectionPanel pnl = (AttributeSelectionPanel)panel;
        ArrayList list = (ArrayList)data;
        this.deserialize(list.get(0), pnl.m_AttributeEvaluatorEditor);
        this.deserialize(list.get(1), pnl.m_AttributeSearchEditor);
        Hashtable options = (Hashtable)list.get(2);
        String tmp = (String)options.get(KEY_TEST);
        if (tmp.equals(VALUE_TRAINING_SET)) {
            pnl.m_TrainBut.setSelected(true);
        } else if (tmp.equals(VALUE_CROSS_VALIDATION)) {
            pnl.m_CVBut.setSelected(true);
        }
        pnl.m_CVText.setText((String)options.get(KEY_CV_FOLDS));
        pnl.m_SeedText.setText((String)options.get(KEY_RANDOM_SEED));
        pnl.m_ClassCombo.setSelectedIndex((Integer)options.get(KEY_CLASS_INDEX));
        this.deserialize(list.get(3), pnl.m_History);
    }
}

