/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import adams.core.Range;
import adams.data.instance.Instance;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.RecentFileEvent;
import adams.gui.event.RecentFileListener;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.gui.ConverterFileChooser;
import weka.gui.explorer.ClassifierPanel;
import weka.gui.explorer.Explorer;
import weka.gui.sql.SqlViewerDialog;

public class ExplorerExt
extends Explorer
implements MenuBarProvider {
    private static final long serialVersionUID = 173388459172775839L;
    public static final String SESSION_FILE = "ExplorerSession.props";
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemLoadRecent;
    protected RecentFilesHandler m_RecentFilesHandler;
    protected JMenuItem m_MenuItemFileSave;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileLoadClassifier;
    protected JMenuItem m_MenuItemFileLoadClusterer;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditData;
    protected JMenuItem m_MenuItemViewInstanceExplorer;
    protected JButton m_ButtonUndo;
    protected JButton m_ButtonEdit;
    protected ConverterFileChooser m_FileChooser;
    protected File m_CurrentFile;
    protected TitleGenerator m_TitleGenerator;

    public ExplorerExt() {
        this.initialize();
        this.initGUI();
    }

    protected void initialize() {
        this.m_RecentFilesHandler = null;
        this.m_FileChooser = null;
        this.m_ButtonUndo = null;
        this.m_ButtonEdit = null;
        this.m_CurrentFile = null;
        this.m_TitleGenerator = new TitleGenerator("Explorer", true);
    }

    protected void initGUI() {
        this.hideButtons((Container)this.getPreprocessPanel());
        this.m_FileChooser = this.getPreprocessPanel().m_FileChooser;
    }

    protected boolean hideButtons(Container cont) {
        boolean result = false;
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            if (cont.getComponent(i) instanceof JButton) {
                if (((JButton)cont.getComponent(i)).getText().equals("Edit...")) {
                    this.m_ButtonEdit = (JButton)cont.getComponent(i);
                    cont.setVisible(false);
                    result = true;
                    continue;
                }
                if (!((JButton)cont.getComponent(i)).getText().equals("Undo")) continue;
                this.m_ButtonUndo = (JButton)cont.getComponent(i);
                continue;
            }
            if (cont.getComponent(i) instanceof Container && (result = this.hideButtons((Container)cont.getComponent(i)))) break;
        }
        return result;
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExplorerExt.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.open();
                }
            });
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, 10, submenu);
            this.m_RecentFilesHandler.addRecentFileListener(new RecentFileListener(){

                public void recentFileAdded(RecentFileEvent e) {
                }

                public void recentFileSelected(RecentFileEvent e) {
                    ExplorerExt.this.openRecent(e);
                }
            });
            this.m_MenuItemLoadRecent = submenu;
            menuitem = new JMenuItem("Load from URL...");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('U');
            menuitem.setIcon(GUIHelper.getIcon((String)"internet.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.loadFromURL();
                }
            });
            menuitem = new JMenuItem("Load from database...");
            menu.add(menuitem);
            menuitem.setMnemonic('L');
            menuitem.setIcon(GUIHelper.getIcon((String)"database.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.loadFromDatabase();
                }
            });
            menuitem = new JMenuItem("Generate...");
            menu.add(menuitem);
            menuitem.setMnemonic('G');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.generate();
                }
            });
            menuitem = new JMenuItem("Save");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.save();
                }
            });
            this.m_MenuItemFileSave = menuitem;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Load classifier model...");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('c');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.loadClassifier();
                }
            });
            this.m_MenuItemFileLoadClassifier = menuitem;
            menuitem = new JMenuItem("Load clusterer model...");
            menu.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.loadClusterer();
                }
            });
            this.m_MenuItemFileLoadClusterer = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.close();
                }
            });
            menu = new JMenu("Edit");
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExplorerExt.this.updateMenu();
                }
            });
            result.add(menu);
            menuitem = new JMenuItem("Undo");
            menuitem.setMnemonic('U');
            menuitem.setEnabled(this.canUndo());
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Z"));
            menuitem.setIcon(GUIHelper.getIcon((String)"undo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.undo();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditUndo = menuitem;
            menuitem = new JMenuItem("Data editor");
            menuitem.setMnemonic('D');
            menuitem.setEnabled(this.canUndo());
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed E"));
            menuitem.setIcon(GUIHelper.getIcon((String)"report.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.edit();
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            this.m_MenuItemEditData = menuitem;
            menu = new JMenu("View");
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExplorerExt.this.updateMenu();
                }
            });
            result.add(menu);
            menuitem = new JMenuItem("Instance Explorer");
            menuitem.setMnemonic('I');
            menuitem.setEnabled(this.canUndo());
            menuitem.setIcon(GUIHelper.getIcon((String)"chart.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplorerExt.this.showInstanceExplorer();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemViewInstanceExplorer = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    protected void updateTitle() {
        String title = this.m_TitleGenerator.generate(this.m_CurrentFile);
        this.setParentTitle(title);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSave.setEnabled(this.isDataLoaded() && this.m_CurrentFile != null);
        this.m_MenuItemFileSaveAs.setEnabled(this.isDataLoaded());
        this.m_MenuItemLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemFileLoadClassifier.setEnabled(this.isDataLoaded() && this.hasClassifyTab());
        this.m_MenuItemFileLoadClusterer.setEnabled(this.isDataLoaded() && this.hasClusterTab());
        this.m_MenuItemEditUndo.setEnabled(this.canUndo());
        this.m_MenuItemEditData.setEnabled(this.canEdit());
        this.m_MenuItemViewInstanceExplorer.setEnabled(this.isDataLoaded());
    }

    protected Integer getDataHashcode() {
        Integer result = null;
        if (this.getPreprocessPanel().getInstances() != null) {
            result = this.getPreprocessPanel().getInstances().hashCode();
        }
        return result;
    }

    public void open() {
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        try {
            this.getPreprocessPanel().addUndoPoint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_FileChooser.getLoader() == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"Cannot determine file loader automatically!", (String)"Load Instances");
            return;
        }
        if (this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentFile(this.m_FileChooser.getSelectedFile());
        }
        this.getPreprocessPanel().setInstancesFromFile(this.m_FileChooser.getLoader());
        this.m_CurrentFile = this.m_FileChooser.getSelectedFile();
        this.update();
    }

    public void open(File file) {
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)file);
        if (loader == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to determine file loader for the following file:\n" + file));
            return;
        }
        try {
            loader.setFile(file);
            this.getPreprocessPanel().setInstancesFromFile(loader);
            this.m_CurrentFile = file;
            this.update();
        }
        catch (Exception ex) {
            System.err.println("Failed to load file:\n" + file);
            ex.printStackTrace();
        }
    }

    public void openRecent(RecentFileEvent e) {
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)e.getFile());
        if (loader == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to determine file loader for the following file:\n" + e.getFile()));
            return;
        }
        try {
            loader.setFile(e.getFile());
            this.getPreprocessPanel().setInstancesFromFile(loader);
            this.m_CurrentFile = e.getFile();
            this.update();
        }
        catch (Exception ex) {
            System.err.println("Failed to load file:\n" + e.getFile());
            ex.printStackTrace();
        }
    }

    public void loadFromDatabase() {
        SqlViewerDialog dialog = new SqlViewerDialog(null);
        dialog.setVisible(true);
        if (dialog.getReturnValue() == 0) {
            this.getPreprocessPanel().setInstancesFromDBQ(dialog.getURL(), dialog.getUser(), dialog.getPassword(), dialog.getQuery(), dialog.getGenerateSparseData());
            this.m_CurrentFile = null;
            this.update();
        }
    }

    public void loadFromURL() {
        this.getPreprocessPanel().setInstancesFromURLQ();
        this.m_CurrentFile = null;
        this.update();
    }

    public void generate() {
        this.getPreprocessPanel().generateInstances();
        this.m_CurrentFile = null;
        this.update();
    }

    public void save() {
        if (this.m_CurrentFile == null) {
            this.saveAs();
            return;
        }
        AbstractFileSaver saver = ConverterUtils.getSaverForFile((File)this.m_CurrentFile);
        if (saver == null) {
            this.saveAs();
            return;
        }
        this.getPreprocessPanel().saveInstancesToFile(saver, this.getPreprocessPanel().getInstances());
    }

    public void saveAs() {
        this.getPreprocessPanel().saveWorkingInstancesToFileQ();
        this.m_CurrentFile = this.m_FileChooser.getSelectedFile();
    }

    public ClassifierPanel getClassifyTab() {
        ClassifierPanel result = null;
        for (Explorer.ExplorerPanel panel : this.getPanels()) {
            if (!(panel instanceof ClassifierPanel)) continue;
            result = (ClassifierPanel)panel;
            break;
        }
        return result;
    }

    public boolean hasClassifyTab() {
        return this.getClassifyTab() != null;
    }

    public void loadClassifier() {
        if (!this.hasClassifyTab() || !this.isDataLoaded()) {
            return;
        }
        this.getClassifyTab().loadClassifier();
    }

    public ClassifierPanel getClusterTab() {
        ClassifierPanel result = null;
        for (Explorer.ExplorerPanel panel : this.getPanels()) {
            if (!(panel instanceof ClassifierPanel)) continue;
            result = (ClassifierPanel)panel;
            break;
        }
        return result;
    }

    public boolean hasClusterTab() {
        return this.getClusterTab() != null;
    }

    public void loadClusterer() {
        if (!this.hasClusterTab() || !this.isDataLoaded()) {
            return;
        }
        this.getClusterTab().loadClassifier();
    }

    public void close() {
        if (GUIHelper.getParentDialog((Container)((Object)this)) != null) {
            GUIHelper.getParentDialog((Container)((Object)this)).setVisible(false);
        } else if (GUIHelper.getParentFrame((Container)((Object)this)) != null) {
            GUIHelper.getParentFrame((Container)((Object)this)).setVisible(false);
        }
    }

    public boolean isDataLoaded() {
        return this.getPreprocessPanel().getInstances() != null;
    }

    public boolean canUndo() {
        if (this.m_ButtonUndo == null) {
            return false;
        }
        return this.m_ButtonUndo.isEnabled();
    }

    public void undo() {
        if (this.m_ButtonUndo != null && this.m_ButtonUndo.isEnabled()) {
            this.m_ButtonUndo.doClick();
        }
    }

    public boolean canEdit() {
        if (this.m_ButtonEdit == null) {
            return false;
        }
        return this.m_ButtonEdit.isEnabled();
    }

    public void edit() {
        if (this.m_ButtonEdit != null && this.m_ButtonEdit.isEnabled()) {
            this.m_ButtonEdit.doClick();
        }
    }

    public void showInstanceExplorer() {
        if (!this.isDataLoaded()) {
            return;
        }
        Instances data = this.getPreprocessPanel().getInstances();
        String rangeStr = JOptionPane.showInputDialog((Component)((Object)this), "Enter range of rows to display:", "first-last");
        if (rangeStr == null) {
            return;
        }
        if (!Range.isValid((String)rangeStr, (int)data.numInstances())) {
            return;
        }
        Range range = new Range(rangeStr);
        range.setMax(data.numInstances());
        int[] indices = range.getIntIndices();
        ApprovalDialog dialog = GUIHelper.getParentDialog((Container)((Object)this)) != null ? ApprovalDialog.getInformationDialog((Dialog)GUIHelper.getParentDialog((Container)((Object)this))) : ApprovalDialog.getInformationDialog((Frame)GUIHelper.getParentFrame((Container)((Object)this)));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.ModalityType.MODELESS);
        dialog.setTitle("Instance Explorer - " + data.relationName());
        InstancePanel panel = new InstancePanel();
        dialog.getContentPane().add((Component)((Object)panel), "Center");
        dialog.setSize(800, 600);
        dialog.setLocationRelativeTo((Component)((Object)this));
        InstanceContainerManager manager = (InstanceContainerManager)panel.getContainerManager();
        manager.startUpdate();
        for (int index : indices) {
            Instance inst = new Instance();
            inst.set(data.instance(index));
            inst.setID("" + (index + 1));
            manager.add(manager.newContainer((Comparable)((Object)inst)));
        }
        manager.finishUpdate();
        dialog.setVisible(true);
    }

    public void setTitle(String value) {
        this.m_TitleGenerator.setTitle(value);
        this.update();
    }

    public String getTitle() {
        return this.m_TitleGenerator.getTitle();
    }

    protected void setParentTitle(String value) {
        if (GUIHelper.getParentDialog((Container)((Object)this)) != null) {
            GUIHelper.getParentDialog((Container)((Object)this)).setTitle(value);
        } else if (GUIHelper.getParentFrame((Container)((Object)this)) != null) {
            GUIHelper.getParentFrame((Container)((Object)this)).setTitle(value);
        }
    }

    protected void setCurrentFile(File value) {
        this.m_CurrentFile = value;
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public ConverterFileChooser getFileChooser() {
        return this.m_FileChooser;
    }
}

