/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import adams.core.Utils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import weka.gui.explorer.ExplorerEntryPanel;
import weka.gui.explorer.ExplorerExt;
import weka.gui.explorer.WorkspaceHelper;

public class MultiExplorer
extends BasePanel
implements AbstractNamedHistoryPanel.PopupCustomizer {
    private static final long serialVersionUID = -20320489406680254L;
    public static final String DEFAULT_NAME = "Session";
    protected JSplitPane m_SplitPane;
    protected ExplorerEntryPanel m_History;
    protected BasePanel m_PanelExplorer;
    protected BasePanel m_PanelHistory;
    protected BasePanel m_PanelButtons;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonCopy;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonWorkspace;
    protected BaseFileChooser m_WorkspaceFileChooser;

    protected void initialize() {
        super.initialize();
        this.m_WorkspaceFileChooser = WorkspaceHelper.newFileChooser();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new JSplitPane();
        this.add(this.m_SplitPane, "Center");
        this.m_PanelExplorer = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelExplorer.setMinimumSize(new Dimension(100, 0));
        this.m_SplitPane.setBottomComponent((Component)this.m_PanelExplorer);
        this.m_History = new ExplorerEntryPanel();
        this.m_History.setPanel(this.m_PanelExplorer);
        this.m_History.setPopupCustomizer(this);
        this.m_PanelHistory = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelHistory.setMinimumSize(new Dimension(100, 0));
        this.m_PanelHistory.add((Component)((Object)this.m_History), (Object)"Center");
        this.m_PanelButtons = new BasePanel((LayoutManager)new FlowLayout(0));
        this.m_PanelHistory.add((Component)this.m_PanelButtons, (Object)"South");
        this.m_SplitPane.setTopComponent((Component)this.m_PanelHistory);
        this.m_ButtonAdd = new JButton(GUIHelper.getIcon((String)"add.gif"));
        int height = this.m_ButtonAdd.getHeight();
        this.m_ButtonAdd.setSize(height, height);
        this.m_ButtonAdd.setToolTipText("Adds a new Explorer panel");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String initial = MultiExplorer.this.m_History.newEntryName(MultiExplorer.DEFAULT_NAME);
                String name = JOptionPane.showInputDialog((Component)((Object)MultiExplorer.this), "Please enter the name for the Explorer panel:", initial);
                if (name == null) {
                    return;
                }
                MultiExplorer.this.addPanel(new ExplorerExt(), name);
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonAdd);
        this.m_ButtonCopy = new JButton(GUIHelper.getIcon((String)"copy.gif"));
        this.m_ButtonCopy.setSize(height, height);
        this.m_ButtonCopy.setToolTipText("Creates a copy of the currently selected Explorer panel");
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerExt oldExplorer = (ExplorerExt)((Object)MultiExplorer.this.m_History.getEntry(MultiExplorer.this.m_History.getSelectedIndex()));
                String name = "Copy of " + MultiExplorer.this.m_History.getSelectedEntry();
                name = MultiExplorer.this.m_History.newEntryName(name);
                ExplorerExt newExplorer = new ExplorerExt();
                newExplorer.setCurrentFile(oldExplorer.getCurrentFile());
                if (oldExplorer.getPreprocessPanel().getInstances() != null) {
                    newExplorer.getFileChooser().setCurrentDirectory(oldExplorer.getFileChooser().getCurrentDirectory());
                    newExplorer.getPreprocessPanel().setInstances(oldExplorer.getPreprocessPanel().getInstances());
                }
                MultiExplorer.this.addPanel(newExplorer, name);
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonCopy);
        this.m_ButtonRemove = new JButton(GUIHelper.getIcon((String)"remove.gif"));
        this.m_ButtonRemove.setSize(height, height);
        this.m_ButtonRemove.setToolTipText("Removes all selected Explorer panels");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = MultiExplorer.this.m_History.getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    MultiExplorer.this.removePanel(indices[i]);
                }
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonRemove);
        this.m_ButtonWorkspace = new JButton(GUIHelper.getIcon((String)"workspace.png"));
        this.m_ButtonWorkspace.setSize(height, height);
        this.m_ButtonWorkspace.setToolTipText("Loading/saving of workspaces");
        this.m_ButtonWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem menuitem = new JMenuItem("Open...");
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MultiExplorer.this.openWorkspace();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Save as...");
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MultiExplorer.this.saveWorkspace();
                    }
                });
                menu.add(menuitem);
                menu.show(MultiExplorer.this.m_ButtonWorkspace, 0, MultiExplorer.this.m_ButtonWorkspace.getHeight());
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonWorkspace);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(0.0);
        this.m_SplitPane.setDividerLocation(250);
        this.m_History.addHistoryEntrySelectionListener(new AbstractNamedHistoryPanel.HistoryEntrySelectionListener(){

            public void historyEntrySelected(AbstractNamedHistoryPanel.HistoryEntrySelectionEvent e) {
                MultiExplorer.this.m_ButtonCopy.setEnabled(e.getNames().length == 1);
            }
        });
    }

    protected void finishInit() {
        super.finishInit();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                MultiExplorer.this.addPanel(new ExplorerExt(), MultiExplorer.DEFAULT_NAME);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void clear() {
        this.m_History.clear();
        this.m_PanelExplorer.removeAll();
    }

    public int count() {
        return this.m_History.count();
    }

    public ExplorerEntryPanel getHistory() {
        return this.m_History;
    }

    public synchronized void addPanel(ExplorerExt panel, String name) {
        this.m_History.addEntry(this.m_History.newEntryName(name), (Object)panel);
        this.m_History.setSelectedIndex(this.count() - 1);
    }

    public synchronized boolean removePanel(String name) {
        boolean result = false;
        if (!this.m_History.hasEntry(name)) {
            return result;
        }
        int index = this.m_History.indexOfEntry(name);
        boolean bl = result = this.m_History.removeEntry(name) != null;
        if (this.m_History.count() > 0) {
            if (this.m_History.count() <= index) {
                --index;
            }
            this.m_History.updateEntry(this.m_History.getEntryName(index));
        }
        return result;
    }

    public synchronized boolean removePanel(int index) {
        return this.removePanel(this.m_History.getEntryName(index));
    }

    public ExplorerExt getPanel(String name) {
        return (ExplorerExt)((Object)this.m_History.getEntry(name));
    }

    public void load(File file) {
        this.load(new File[]{file});
    }

    public void load(File[] files) {
        for (final File file : files) {
            String name = file.getName();
            if (name.lastIndexOf(46) > -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            final ExplorerExt panel = new ExplorerExt();
            this.addPanel(panel, name);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    panel.open(file);
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    public void customizePopup(final String[] entries, JPopupMenu menu) {
        if (entries.length == 1) {
            JMenuItem menuitem = new JMenuItem("Rename...");
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = JOptionPane.showInputDialog((Component)((Object)MultiExplorer.this), "Please enter the new name:", entries[0]);
                    if (newName == null) {
                        return;
                    }
                    if (entries[0].equals(newName)) {
                        return;
                    }
                    String msg = MultiExplorer.this.m_History.renameEntry(entries[0], newName);
                    if (msg != null) {
                        GUIHelper.showErrorMessage((Component)((Object)MultiExplorer.this), (String)msg);
                    }
                }
            });
            menu.add(menuitem);
        }
    }

    protected void openWorkspace() {
        VFSJFileChooser.RETURN_TYPE retVal = this.m_WorkspaceFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        File file = this.m_WorkspaceFileChooser.getSelectedFile();
        try {
            WorkspaceHelper.read(file, this);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to open workspace '" + file + "'!\n" + Utils.throwableToString((Throwable)e)));
        }
    }

    public void saveWorkspace() {
        VFSJFileChooser.RETURN_TYPE retVal = this.m_WorkspaceFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        File file = this.m_WorkspaceFileChooser.getSelectedFile();
        try {
            WorkspaceHelper.write(this, file);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save workspace to '" + file + "'!\n" + Utils.throwableToString((Throwable)e)));
        }
    }

    public ExplorerEntryPanel getEntryPanel() {
        return this.m_History;
    }
}

