/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.gui.explorer.AbstractExplorerPanelHandler;
import weka.gui.explorer.DefaultHandler;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerExt;
import weka.gui.explorer.MultiExplorer;
import weka.gui.explorer.PreprocessPanel;

public class WorkspaceHelper {
    public static final String KEY_LOG = "log";

    public static BaseFileChooser newFileChooser() {
        BaseFileChooser result = new BaseFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter("Explorer workspace", "ews");
        result.addChoosableFileFilter((AbstractVFSFileFilter)filter);
        result.setDefaultExtension("ews");
        result.setFileFilter((AbstractVFSFileFilter)filter);
        result.setAutoAppendExtension(true);
        result.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_ONLY);
        result.setMultiSelectionEnabled(false);
        return result;
    }

    protected static AbstractExplorerPanelHandler[] getHandlers() throws Exception {
        String[] cnames = AbstractExplorerPanelHandler.getHandlers();
        ArrayList<AbstractExplorerPanelHandler> handlers = new ArrayList<AbstractExplorerPanelHandler>();
        int def = -1;
        for (int i = 0; i < cnames.length; ++i) {
            if (cnames[i].equals(DefaultHandler.class.getName())) {
                def = i;
            }
            handlers.add((AbstractExplorerPanelHandler)Class.forName(cnames[i]).newInstance());
        }
        if (def != -1 && handlers.size() > 1) {
            AbstractExplorerPanelHandler handler = (AbstractExplorerPanelHandler)handlers.remove(def);
            handlers.add(handler);
        }
        return handlers.toArray(new AbstractExplorerPanelHandler[handlers.size()]);
    }

    protected static Hashtable<String, Object> getExplorerOptions(Explorer explorer) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        return result;
    }

    public static void write(MultiExplorer explorer, File file) throws Exception {
        AbstractExplorerPanelHandler[] handlers = WorkspaceHelper.getHandlers();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        oos.writeObject(explorer.getEntryPanel().count());
        for (int i = 0; i < explorer.getEntryPanel().count(); ++i) {
            String name = explorer.getEntryPanel().getEntryName(i);
            ExplorerExt expext = (ExplorerExt)((Object)explorer.getEntryPanel().getEntry(i));
            oos.writeObject(name);
            oos.writeObject(WorkspaceHelper.getExplorerOptions(expext));
            oos.writeObject(expext.getPanels().size() + 1);
            ArrayList<PreprocessPanel> panels = new ArrayList<PreprocessPanel>();
            panels.add(expext.getPreprocessPanel());
            panels.addAll(expext.getPanels());
            block1: for (Explorer.ExplorerPanel explorerPanel : panels) {
                for (AbstractExplorerPanelHandler handler : handlers) {
                    if (!handler.handles(explorerPanel)) continue;
                    oos.writeObject(explorerPanel.getClass().getName());
                    oos.writeObject(handler.getClass().getName());
                    oos.writeObject(handler.serialize(explorerPanel));
                    continue block1;
                }
            }
        }
        oos.flush();
        oos.close();
    }

    protected static void setExplorerOptions(Explorer explorer, Hashtable<String, Object> options) {
    }

    public static void read(File file, MultiExplorer explorer) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        explorer.getEntryPanel().clear();
        int expCount = (Integer)ois.readObject();
        for (int i = 0; i < expCount; ++i) {
            ExplorerExt expext = new ExplorerExt();
            String name = (String)ois.readObject();
            Hashtable options = (Hashtable)ois.readObject();
            int panelCount = (Integer)ois.readObject();
            WorkspaceHelper.setExplorerOptions(expext, options);
            explorer.addPanel(expext, name);
            ArrayList<PreprocessPanel> panels = new ArrayList<PreprocessPanel>();
            panels.add(expext.getPreprocessPanel());
            panels.addAll(expext.getPanels());
            block1: for (int n = 0; n < panelCount; ++n) {
                Class<?> cpanel = Class.forName((String)ois.readObject());
                AbstractExplorerPanelHandler handler = (AbstractExplorerPanelHandler)Class.forName((String)ois.readObject()).newInstance();
                for (Explorer.ExplorerPanel explorerPanel : panels) {
                    if (!explorerPanel.getClass().equals(cpanel)) continue;
                    handler.deserialize(explorerPanel, ois.readObject());
                    continue block1;
                }
            }
        }
        ois.close();
    }
}

