/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PasswordTools {
    private static final String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDREFGHIJKLMNOPQRSTUVWXYZ";
    private static Cipher ecipher;
    private static Cipher dcipher;

    public static char[] createRandom(int length) {
        Random rand = new Random(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i <= length) {
            int pos = rand.nextInt(CHARS.length());
            sb.append(CHARS.charAt(pos));
            ++i;
        }
        return sb.toString().toCharArray();
    }

    public static byte[] decrypt(byte[] bytes) {
        try {
            return dcipher.doFinal(bytes);
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        return null;
    }

    public static char[] decrypt(String value) {
        try {
            byte[] bytes = Base64.decode(StringTools.toByteArray(value));
            byte[] decrypted = PasswordTools.decrypt(bytes);
            return new String(decrypted, "UTF8").toCharArray();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] encrypt(byte[] bytes) {
        try {
            return ecipher.doFinal(bytes);
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        return null;
    }

    public static String encrypt(char[] value) {
        try {
            byte[] bytes = new String(value).getBytes("UTF8");
            byte[] encrypted = PasswordTools.encrypt(bytes);
            return new String(Base64.encode(encrypted));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String hash(char[] password) {
        if (StringTools.isEmpty(password)) {
            return "";
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return new String(password);
        }
        try {
            md.update(new String(password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new String(password);
        }
        byte[] raw = md.digest();
        return new String(Base64.encode(raw));
    }

    public static void initialize(byte[] salt, char[] passphrase) {
        try {
            int iterationCount = 19;
            PBEKeySpec keySpec = new PBEKeySpec(passphrase, salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            ecipher = Cipher.getInstance(key.getAlgorithm());
            dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            ecipher.init(1, (Key)key, paramSpec);
            dcipher.init(2, (Key)key, paramSpec);
        }
        catch (Exception e) {
            throw new IllegalStateException("can't initialize password tools", e);
        }
    }
}

