/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import de.intarsys.tools.reporter.ReportDispatcher;
import de.intarsys.tools.reporter.ReportMessage;

public class ReplayReporter
implements IReporter,
IReporterSupport {
    private final Object owner;
    private final ReportDispatcher dispatcher;
    private final ReportMessage[] messages = new ReportMessage[10];
    private int first = 0;

    public ReplayReporter(Object owner) {
        this.owner = owner;
        this.dispatcher = new ReportDispatcher(owner);
    }

    protected void addMessage(ReportMessage message) {
        this.messages[this.first] = message;
        this.first = (this.first + 1) % this.messages.length;
    }

    public void addReporter(IReporter reporter) {
        this.dispatcher.addReporter(reporter);
        this.replay(reporter);
    }

    public Object getOwner() {
        return this.owner;
    }

    public void removeReporter(IReporter reporter) {
        this.dispatcher.removeReporter(reporter);
    }

    protected void replay(IReporter reporter) {
        int i = 0;
        while (i < this.messages.length) {
            int index = (i + this.first) % this.messages.length;
            ReportMessage message = this.messages[index];
            if (message != null) {
                if (message.isStatus()) {
                    reporter.reportStatus(message.getMessage(), message.getStyle());
                } else if (message.isMessage()) {
                    reporter.reportMessage(message.getTitle(), message.getMessage(), message.getStyle());
                } else if (message.isError()) {
                    reporter.reportError(message.getTitle(), message.getMessage(), message.getThrowable(), message.getStyle());
                }
            }
            ++i;
        }
    }

    public void reportActivityEnd() {
        this.addMessage(new ReportMessage(2, null, null, 0, 0, null));
        this.dispatcher.reportActivityEnd();
    }

    public void reportActivityStart(String activity, int style) {
        this.addMessage(new ReportMessage(1, null, activity, style, 0, null));
        this.dispatcher.reportActivityStart(activity, style);
    }

    public void reportError(String title, String message, Throwable t, int style) {
        this.addMessage(new ReportMessage(5, title, message, style, 0, t));
        this.dispatcher.reportError(title, message, t, style);
    }

    public void reportMessage(String title, String message, int style) {
        this.addMessage(new ReportMessage(4, title, message, style, 0, null));
        this.dispatcher.reportMessage(title, message, style);
    }

    public void reportProgress(String message, int percent, int style) {
        this.addMessage(new ReportMessage(0, null, message, style, percent, null));
        this.dispatcher.reportProgress(message, percent, style);
    }

    public void reportStatus(String message, int style) {
        this.addMessage(new ReportMessage(3, null, message, style, 0, null));
        this.dispatcher.reportStatus(message, style);
    }
}

