/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import java.io.Serializable;

public abstract class AbstractGPS
implements Serializable,
Comparable<AbstractGPS>,
Cloneable {
    private static final long serialVersionUID = -9037112025830141712L;
    public static final int NUM_DECIMALS = 10;
    protected Coordinate m_Longitude;
    protected Coordinate m_Latitude;

    public AbstractGPS() {
        this(new Coordinate(), new Coordinate());
    }

    public AbstractGPS(String s) {
        this();
        this.fromString(s);
    }

    public AbstractGPS(AbstractGPS gps) {
        this(gps.getLatitude().clone(), gps.getLongitude().clone());
    }

    public AbstractGPS(double lat, double lon) {
        this(new Coordinate(lat), new Coordinate(lon));
    }

    public AbstractGPS(Coordinate lat, Coordinate lon) {
        this.m_Longitude = lon;
        this.m_Latitude = lat;
    }

    public Coordinate getLongitude() {
        return this.m_Longitude;
    }

    public Coordinate getLatitude() {
        return this.m_Latitude;
    }

    protected abstract AbstractGPS clone();

    @Override
    public int compareTo(AbstractGPS o) {
        if (o == null) {
            return 1;
        }
        int result = this.m_Latitude.compareTo(o.m_Latitude);
        if (result == 0) {
            result = this.m_Longitude.compareTo(o.m_Longitude);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractGPS) {
            return this.compareTo((AbstractGPS)o) == 0;
        }
        return false;
    }

    protected String preprocess(String s) {
        if (s.startsWith("(") && s.endsWith(")")) {
            return s.replace("(", "").replace(",", "").replace(")", "");
        }
        return s;
    }

    public abstract void fromString(String var1);

    public abstract String toString();
}

