/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import java.io.Serializable;

public class Coordinate
implements Serializable,
Comparable<Coordinate>,
Cloneable {
    private static final long serialVersionUID = -5163361656893487847L;
    protected int m_Degree;
    protected int m_Minute;
    protected double m_Second;

    public Coordinate() {
        this(0, 0, 0.0);
    }

    public Coordinate(int deg, int min, double sec) {
        this.m_Degree = deg;
        this.m_Minute = min;
        this.m_Second = sec;
    }

    public Coordinate(double deg) {
        int intPart;
        double mod = deg % 1.0;
        int degree = intPart = (int)deg;
        deg = Math.abs(mod * 60.0);
        mod = deg % 1.0;
        int minute = intPart = (int)deg;
        deg = mod * 60.0;
        this.m_Degree = degree;
        this.m_Minute = minute;
        this.m_Second = deg;
    }

    public int getDegree() {
        return this.m_Degree;
    }

    public int getMinute() {
        return this.m_Minute;
    }

    public double getSecond() {
        return this.m_Second;
    }

    public double toDecimal() {
        double seconds = (double)this.m_Minute * 60.0 + this.m_Second;
        double frac = seconds / 3600.0;
        if (this.m_Degree < 0) {
            return -((double)(-this.m_Degree) + frac);
        }
        return (double)this.m_Degree + frac;
    }

    protected Coordinate clone() {
        return new Coordinate(this.m_Degree, this.m_Minute, this.m_Second);
    }

    @Override
    public int compareTo(Coordinate o) {
        if (o == null) {
            return 1;
        }
        int result = new Integer(this.m_Degree).compareTo(o.m_Degree);
        if (result == 0) {
            result = new Integer(this.m_Minute).compareTo(o.m_Minute);
        }
        if (result == 0) {
            result = new Double(this.m_Second).compareTo(o.m_Second);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Coordinate) {
            return this.compareTo((Coordinate)o) == 0;
        }
        return false;
    }

    public String toString() {
        return this.m_Degree + ":" + this.m_Minute + ":" + this.m_Second;
    }
}

