/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.core.Utils;
import adams.data.gps.AbstractGPS;
import adams.data.gps.Coordinate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GPSDecimalDegrees
extends AbstractGPS {
    private static final long serialVersionUID = 1902709328711736523L;
    public static final String FORMAT = "([NnSs\\+-]?)\\s*(\\d+)\\.(\\d+)\\s*([WwEe\\+-]?)\\s*(\\d+)\\.(\\d+)";

    public GPSDecimalDegrees() {
    }

    public GPSDecimalDegrees(String s) {
        super(s);
    }

    public GPSDecimalDegrees(AbstractGPS gps) {
        super(gps);
    }

    public GPSDecimalDegrees(double lat, double lon) {
        super(lat, lon);
    }

    public GPSDecimalDegrees(Coordinate lat, Coordinate lon) {
        super(lat, lon);
    }

    @Override
    protected GPSDecimalDegrees clone() {
        return new GPSDecimalDegrees(this);
    }

    @Override
    public void fromString(String s) {
        s = this.preprocess(s);
        Pattern pattern = Pattern.compile(FORMAT);
        Matcher matcher = pattern.matcher(s);
        double latsign = 1.0;
        double longsign = 1.0;
        if (matcher.matches()) {
            String slatsign = matcher.group(1);
            String slongsign = matcher.group(4);
            if (slatsign.equalsIgnoreCase("S") || slatsign.equals("-")) {
                latsign = -1.0;
            }
            if (slongsign.equalsIgnoreCase("E") || slongsign.equals("-")) {
                longsign = -1.0;
            }
            double latdegrees = (double)Integer.parseInt(matcher.group(2)) * latsign;
            double longdegrees = (double)Integer.parseInt(matcher.group(5)) * longsign;
            this.m_Latitude = new Coordinate(latdegrees += Double.parseDouble("." + matcher.group(3)));
            this.m_Longitude = new Coordinate(longdegrees += Double.parseDouble("." + matcher.group(6)));
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        double lat = this.m_Latitude.toDecimal();
        double lon = this.m_Longitude.toDecimal();
        if (lat < 0.0) {
            result.append("S");
        } else {
            result.append("N");
        }
        result.append(Utils.doubleToString((double)Math.abs(lat), (int)10));
        result.append(" ");
        if (lon < 0.0) {
            result.append("E");
        } else {
            result.append("W");
        }
        result.append(Utils.doubleToString((double)Math.abs(lon), (int)10));
        return result.toString();
    }
}

