/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.core.Utils;
import adams.data.gps.AbstractGPS;
import adams.data.gps.Coordinate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GPSDecimalMinutes
extends AbstractGPS {
    private static final long serialVersionUID = 8682798854401575189L;
    public static final String FORMAT = "([NnSs\\+-]?)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)\\s*([WwEe\\+-]?)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)";

    public GPSDecimalMinutes() {
    }

    public GPSDecimalMinutes(String s) {
        super(s);
    }

    public GPSDecimalMinutes(AbstractGPS gps) {
        super(gps);
    }

    public GPSDecimalMinutes(double lat, double lon) {
        super(lat, lon);
    }

    public GPSDecimalMinutes(Coordinate lat, Coordinate lon) {
        super(lat, lon);
    }

    @Override
    protected GPSDecimalMinutes clone() {
        return new GPSDecimalMinutes(this);
    }

    @Override
    public void fromString(String s) {
        s = this.preprocess(s);
        Pattern pattern = Pattern.compile(FORMAT);
        Matcher matcher = pattern.matcher(s);
        double latsign = 1.0;
        double longsign = 1.0;
        if (matcher.matches()) {
            String slatsign = matcher.group(1);
            String slongsign = matcher.group(5);
            if (slatsign.equalsIgnoreCase("S") || slatsign.equals("-")) {
                latsign = -1.0;
            }
            if (slongsign.equalsIgnoreCase("E") || slongsign.equals("-")) {
                longsign = -1.0;
            }
            double latdegrees = (double)Integer.parseInt(matcher.group(2)) * latsign;
            double longdegrees = (double)Integer.parseInt(matcher.group(6)) * longsign;
            this.m_Latitude = new Coordinate(latdegrees += Double.parseDouble(matcher.group(3) + "." + matcher.group(4)) / 60.0);
            this.m_Longitude = new Coordinate(longdegrees += Double.parseDouble(matcher.group(7) + "." + matcher.group(8)) / 60.0);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        double lat = (double)this.m_Latitude.getMinute() + this.m_Latitude.getSecond() / 60.0;
        double lon = (double)this.m_Longitude.getMinute() + this.m_Longitude.getSecond() / 60.0;
        if (lat < 0.0) {
            result.append("S");
        } else {
            result.append("N");
        }
        result.append(Integer.toString(Math.abs(this.m_Latitude.getDegree())));
        result.append(" ");
        result.append(Utils.doubleToString((double)Math.abs(lat), (int)10));
        result.append(" ");
        if (lon < 0.0) {
            result.append("E");
        } else {
            result.append("W");
        }
        result.append(Integer.toString(Math.abs(this.m_Longitude.getDegree())));
        result.append(" ");
        result.append(Utils.doubleToString((double)Math.abs(lon), (int)10));
        return result.toString();
    }
}

