/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.core.Utils;
import adams.data.gps.AbstractGPS;
import adams.data.gps.Coordinate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GPSDecimalSeconds
extends AbstractGPS {
    private static final long serialVersionUID = 1902709328711736523L;
    public static final String FORMAT = "([NnSs\\+-]?)\\s*(\\d+)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)\\s*([WwEe\\+-]?)\\s*(\\d+)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)\\s*";

    public GPSDecimalSeconds() {
    }

    public GPSDecimalSeconds(String s) {
        super(s);
    }

    public GPSDecimalSeconds(AbstractGPS gps) {
        super(gps);
    }

    public GPSDecimalSeconds(double lat, double lon) {
        super(lat, lon);
    }

    public GPSDecimalSeconds(Coordinate lat, Coordinate lon) {
        super(lat, lon);
    }

    @Override
    protected GPSDecimalSeconds clone() {
        return new GPSDecimalSeconds(this);
    }

    @Override
    public void fromString(String s) {
        s = this.preprocess(s);
        Pattern pattern = Pattern.compile(FORMAT);
        Matcher matcher = pattern.matcher(s);
        double latsign = 1.0;
        double longsign = 1.0;
        if (matcher.matches()) {
            String slatsign = matcher.group(1);
            String slongsign = matcher.group(6);
            if (slatsign.equalsIgnoreCase("S") || slatsign.equals("-")) {
                latsign = -1.0;
            }
            if (slongsign.equalsIgnoreCase("E") || slongsign.equals("-")) {
                longsign = -1.0;
            }
            int latdegrees = Integer.parseInt(matcher.group(2)) * (int)latsign;
            int longdegrees = Integer.parseInt(matcher.group(7)) * (int)longsign;
            int latminutes = Integer.parseInt(matcher.group(3));
            int longminutes = Integer.parseInt(matcher.group(8));
            double latseconds = Double.parseDouble(matcher.group(4) + "." + matcher.group(5));
            double longseconds = Double.parseDouble(matcher.group(9) + "." + matcher.group(10));
            this.m_Latitude = new Coordinate(latdegrees, latminutes, latseconds);
            this.m_Longitude = new Coordinate(longdegrees, longminutes, longseconds);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        double lat = this.m_Latitude.toDecimal();
        double lon = this.m_Longitude.toDecimal();
        if (lat < 0.0) {
            result.append("S");
        } else {
            result.append("N");
        }
        result.append(Integer.toString(Math.abs(this.m_Latitude.getDegree())));
        result.append(" ");
        result.append(Integer.toString(Math.abs(this.m_Latitude.getMinute())));
        result.append(" ");
        result.append(Utils.doubleToString((double)Math.abs(this.m_Latitude.getSecond()), (int)10));
        result.append(" ");
        if (lon < 0.0) {
            result.append("E");
        } else {
            result.append("W");
        }
        result.append(Integer.toString(Math.abs(this.m_Longitude.getDegree())));
        result.append(" ");
        result.append(Integer.toString(Math.abs(this.m_Longitude.getMinute())));
        result.append(" ");
        result.append(Utils.doubleToString((double)Math.abs(this.m_Longitude.getSecond()), (int)10));
        return result.toString();
    }
}

