/*
 * Decompiled with CFR 0.152.
 */
package com.example.customerservice.flow;

import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.flow.webservice.AbstractWebServiceClientTransformerWithGlobalTransformer;
import adams.flow.webservice.WebserviceUtils;
import com.example.customerservice.Customer;
import com.example.customerservice.CustomerService;
import com.example.customerservice.CustomerServiceService;
import java.net.URL;
import java.util.List;

@MixedCopyright(author="Apache CXF", license=License.APACHE2, note="Code from 'WSDL first' example", url="http://cxf.apache.org/docs/sample-projects.html")
public class CustomersByNameGlobalTransformer
extends AbstractWebServiceClientTransformerWithGlobalTransformer<String, String> {
    private static final long serialVersionUID = -5099626472532203256L;
    protected String m_CustomerName;
    protected String m_ProvidedCustomerName;
    protected List<Customer> m_Customers;

    public String globalInfo() {
        return "Returns customer names.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("customer-name", "customerName", (Object)"Smith");
    }

    public void setCustomerName(String value) {
        this.m_CustomerName = value;
        this.reset();
    }

    public String getCustomerName() {
        return this.m_CustomerName;
    }

    public String customerNameTipText() {
        return "The customer name to look up.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public void setRequestData(String value) {
        this.m_ProvidedCustomerName = value;
    }

    @Override
    protected URL getWsdlLocation() {
        return this.getClass().getClassLoader().getResource("wsdl/customerservice/CustomerService.wsdl");
    }

    @Override
    protected void doQuery() throws Exception {
        String name = this.m_ProvidedCustomerName == null ? this.m_CustomerName : this.m_ProvidedCustomerName;
        this.m_Customers = null;
        CustomerServiceService customerServiceService = new CustomerServiceService(this.getWsdlLocation());
        CustomerService customerService = customerServiceService.getCustomerServicePort();
        WebserviceUtils.configureClient(customerService, this.m_ConnectionTimeout, this.m_ReceiveTimeout);
        this.m_Customers = customerService.getCustomersByName(name);
        this.m_ProvidedCustomerName = null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public boolean hasResponseData() {
        return this.m_Customers != null && this.m_Customers.size() > 0;
    }

    @Override
    public String getResponseData() {
        String result = this.m_Customers.get(0).getCustomerId() + ": " + this.m_Customers.get(0).getName() + ", " + Utils.flatten(this.m_Customers.get(0).getAddress(), (String)" ");
        this.m_Customers.remove(0);
        try {
            result = (String)this.applyTransformer(result);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to apply global transformer", e);
        }
        return result;
    }
}

