/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.ImageMetadata;

public class ImageMetaData
extends AbstractTransformer {
    private static final long serialVersionUID = 8005075286840278197L;

    public String globalInfo() {
        return "Returns any EXIF or IPTC information as a spreadsheet.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof String ? new File(new PlaceholderFile((String)this.m_InputToken.getPayload()).getAbsolutePath()) : new File(((File)this.m_InputToken.getPayload()).getAbsolutePath());
        try {
            IImageMetadata meta = Sanselan.getMetadata((File)file);
            SpreadSheet sheet = new SpreadSheet();
            HeaderRow row = sheet.getHeaderRow();
            row.addCell("K").setContent("Key");
            row.addCell("V").setContent("Value");
            for (Object item : meta.getItems()) {
                String key = null;
                String value = null;
                if (item instanceof ImageMetadata.Item) {
                    key = ((ImageMetadata.Item)item).getKeyword();
                    value = ((ImageMetadata.Item)item).getText();
                } else {
                    String[] parts = item.toString().split(": ");
                    if (parts.length == 2) {
                        key = parts[0];
                        value = parts[1];
                    } else if (this.isDebugOn()) {
                        this.debug("Failed to parse: " + item);
                    }
                }
                if (key == null) continue;
                row = sheet.addRow();
                row.addCell("K").setContent(key);
                row.addCell("V").setContent(value);
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        catch (Exception e) {
            result = this.handleException("Failed to read meta-data from: " + file, e);
        }
        return result;
    }
}

