/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Range;
import adams.core.Utils;
import adams.data.io.input.AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.spreadsheet.Sheet;

public class ODFSpreadSheetReader
extends AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport {
    private static final long serialVersionUID = 4755872204697328246L;
    protected Range m_TextColumns;

    public String globalInfo() {
        return "Reads ODF (Open Document Format) spreadsheet files.\nIf a row contains only empty cells, this is interpreted as the end of the sheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("text-columns", "textColumns", (Object)"");
    }

    public String getFormatDescription() {
        return "OpenDocument format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"ods"};
    }

    protected void initialize() {
        super.initialize();
        this.m_TextColumns = new Range();
    }

    public void setTextColumns(String value) {
        this.m_TextColumns.setRange(value);
        this.reset();
    }

    public String getTextColumns() {
        return this.m_TextColumns.getRange();
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text; " + this.m_TextColumns.getExample();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    protected String numericToString(String s) {
        Double dbl = Utils.toDouble((String)s);
        long lng = dbl.longValue();
        if (dbl == (double)lng) {
            return "" + lng;
        }
        return "" + dbl;
    }

    protected List<SpreadSheet> doReadRange(InputStream in) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        try {
            int[] indices;
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.get((ODPackage)new ODPackage(in));
            this.m_SheetRange.setMax(spreadsheet.getSheetCount());
            block10: for (int index : indices = this.m_SheetRange.getIntIndices()) {
                String cellStr;
                int i;
                SpreadSheet spsheet = new SpreadSheet();
                spsheet.setDataRowClass(this.m_DataRowType.getRowClass());
                result.add(spsheet);
                Sheet sheet = spreadsheet.getSheet(index);
                spsheet.setName(sheet.getName());
                HeaderRow row = spsheet.getHeaderRow();
                for (i = 0; i < sheet.getColumnCount() && !this.m_Stopped && (cellStr = sheet.getCellAt(i, 0).getTextValue()).length() != 0; ++i) {
                    row.addCell("" + (i + 1)).setContent(cellStr);
                }
                this.m_TextColumns.setMax(spsheet.getColumnCount());
                for (int n = 1; n < sheet.getRowCount() && !this.m_Stopped; ++n) {
                    Object[] data = new Object[spsheet.getColumnCount()];
                    Cell.ContentType[] cellTypes = new Cell.ContentType[spsheet.getColumnCount()];
                    boolean empty = true;
                    for (i = 0; i < spsheet.getColumnCount(); ++i) {
                        ODValueType type = sheet.getCellAt(i, n).getValueType();
                        cellStr = sheet.getCellAt(i, n).getTextValue();
                        if (this.m_TextColumns.isInRange(i)) {
                            switch (type) {
                                case CURRENCY: 
                                case FLOAT: 
                                case PERCENTAGE: {
                                    data[i] = this.numericToString(cellStr);
                                    break;
                                }
                                default: {
                                    data[i] = cellStr;
                                }
                            }
                            cellTypes[i] = Cell.ContentType.STRING;
                            empty = false;
                        } else if (cellStr.length() > 0) {
                            switch (type) {
                                case DATE: {
                                    data[i] = spsheet.getDateTimeFormat().parse(cellStr);
                                    cellTypes[i] = Cell.ContentType.DATETIME;
                                    break;
                                }
                                case TIME: {
                                    data[i] = spsheet.getTimeFormat().parse(cellStr);
                                    cellTypes[i] = Cell.ContentType.TIME;
                                    break;
                                }
                                case CURRENCY: 
                                case FLOAT: 
                                case PERCENTAGE: {
                                    if (Utils.isLong((String)cellStr)) {
                                        data[i] = Long.parseLong(cellStr);
                                        cellTypes[i] = Cell.ContentType.LONG;
                                        break;
                                    }
                                    data[i] = Utils.toDouble((String)cellStr);
                                    cellTypes[i] = Cell.ContentType.DOUBLE;
                                }
                            }
                            if (data[i] == null) {
                                data[i] = cellStr;
                                cellTypes[i] = Cell.ContentType.STRING;
                            }
                            empty = false;
                        }
                        if (data[i] == null || !data[i].equals(this.m_MissingValue)) continue;
                        data[i] = null;
                    }
                    if (empty) continue block10;
                    row = spsheet.addRow("" + spsheet.getRowCount());
                    for (i = 0; i < data.length; ++i) {
                        if (data[i] == null) {
                            row.addCell("" + (i + 1)).setContent("?");
                            continue;
                        }
                        if (data[i] instanceof Double) {
                            row.addCell("" + (i + 1)).setContent((Double)data[i]);
                            continue;
                        }
                        if (data[i] instanceof Long) {
                            row.addCell("" + (i + 1)).setContent((Long)data[i]);
                            continue;
                        }
                        row.addCell("" + (i + 1)).setContentAsString((String)data[i]);
                    }
                }
            }
        }
        catch (Exception ioe) {
            this.getSystemErr().println("Failed to read data:");
            this.getSystemErr().printStackTrace((Throwable)ioe);
            result = null;
        }
        return result;
    }
}

