/*
 * Decompiled with CFR 0.152.
 */
package adams.core.annotation;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public abstract class AbstractCopyrightProcessor<T extends Annotation>
extends AbstractProcessor {
    protected boolean m_IsFirst = true;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_11;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(List.of("module", "output", "printheader"));
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(List.of(this.getAnnotationClass().getName()));
    }

    protected abstract Class getAnnotationClass();

    protected abstract String getOutputFile(String var1);

    protected abstract String getHeaderRow();

    protected abstract String getDataRow(T var1, String var2, String var3, String var4);

    protected String writeToFile(String filename, Object obj, boolean append) {
        String result = null;
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        lines.add((CallSite)((Object)("" + obj)));
        OpenOption[] options = append ? new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE} : new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        try {
            Files.write(new File(filename).toPath(), lines, options);
        }
        catch (Exception e) {
            result = "Failed to write to '" + filename + "'\n" + e;
        }
        return result;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, String> options = this.processingEnv.getOptions();
        String module = options.getOrDefault("module", "N/A");
        boolean printHeader = options.get("printheader") != null && options.get("printheader").equalsIgnoreCase("true");
        String output = options.get("output");
        if (output != null) {
            output = this.getOutputFile(output);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(this.getAnnotationClass())) {
            String method;
            String cls;
            Object copyright = element.getAnnotation(this.getAnnotationClass());
            if (element.getKind() == ElementKind.CLASS) {
                cls = element.asType().toString();
                method = "";
            } else {
                cls = element.getEnclosingElement().asType().toString();
                method = element.getSimpleName().toString();
            }
            String line = this.getDataRow(copyright, module, cls, method);
            if (output == null) {
                if (this.m_IsFirst && printHeader) {
                    System.out.println(this.getHeaderRow());
                }
                System.out.println(line);
            } else {
                if (this.m_IsFirst && printHeader) {
                    this.writeToFile(output, this.getHeaderRow(), false);
                }
                this.writeToFile(output, line, true);
            }
            this.m_IsFirst = false;
        }
        return true;
    }
}

