/*
 * Decompiled with CFR 0.152.
 */
package adams.core.annotation;

import adams.core.annotation.DeprecatedClass;

public class AnnotationHelper {
    public static boolean hasAnnotation(Class cls, Class annotation) {
        return cls.getAnnotation(annotation) != null;
    }

    public static boolean isDeprecated(Class cls) {
        return AnnotationHelper.hasAnnotation(cls, Deprecated.class) || AnnotationHelper.hasAnnotation(cls, DeprecatedClass.class);
    }

    public static String classesToString(Class[] classes) {
        StringBuilder result = new StringBuilder();
        if (classes != null) {
            for (int i = 0; i < classes.length && classes[i] != null; ++i) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(classes[i].getName());
            }
        }
        return result.toString();
    }

    public static String getDeprecationWarning(Class cls) {
        if (cls.isAnnotationPresent(DeprecatedClass.class)) {
            DeprecatedClass dep = cls.getAnnotation(DeprecatedClass.class);
            return cls.getName() + " is deprecated!\nUse instead: " + AnnotationHelper.classesToString(dep.useInstead());
        }
        if (cls.isAnnotationPresent(Deprecated.class)) {
            return cls.getName() + " is deprecated!";
        }
        return null;
    }
}

