/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.Conversion;
import adams.data.conversion.ExtractSimpleContainerContent;
import adams.data.wavefilter.AbstractWaveFilter;
import adams.data.wavefilter.Trim;
import adams.data.wavefilter.WaveIndexingType;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.AudioData;
import adams.flow.transformer.Convert;
import adams.flow.transformer.WaveFilter;
import adams.flow.transformer.audiodata.AbstractAudioDataReader;
import adams.flow.transformer.audiodata.Wave;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WaveFilterTest
extends AbstractFlowTest {
    public WaveFilterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("cock_a_1.wav");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("cock_a_1.wav");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WaveFilterTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/cock_a_1.wav"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            AudioData audiodata = new AudioData();
            Wave wave = new Wave();
            audiodata.setReader((AbstractAudioDataReader)wave);
            actors.add(audiodata);
            WaveFilter wavefilter = new WaveFilter();
            wavefilter.setName("WaveFilter - left");
            Trim trim = new Trim();
            trim.setType(WaveIndexingType.SECONDS);
            trim.setLeft(0.5);
            wavefilter.setFilter((AbstractWaveFilter)trim);
            actors.add(wavefilter);
            WaveFilter wavefilter2 = new WaveFilter();
            wavefilter2.setName("WaveFilter - right");
            Trim trim2 = new Trim();
            trim2.setType(WaveIndexingType.SECONDS);
            trim2.setRight(0.5);
            wavefilter2.setFilter((AbstractWaveFilter)trim2);
            actors.add(wavefilter2);
            Convert conv = new Convert();
            conv.setConversion((Conversion)new ExtractSimpleContainerContent());
            actors.add(conv);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            WaveFilterTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WaveFilterTest.runTest((Test)WaveFilterTest.suite());
    }
}

