/*
 * Decompiled with CFR 0.152.
 */
package adams.data.audioannotations;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.TimeMsec;
import adams.data.container.AbstractDataPoint;
import adams.data.container.DataPoint;
import java.util.Date;
import java.util.HashMap;

public class AudioAnnotation
extends AbstractDataPoint {
    private static final long serialVersionUID = 7649750314026526010L;
    protected TimeMsec m_Timestamp;
    protected HashMap<String, Object> m_MetaData;
    protected static DateFormat m_DateFormat = DateUtils.getTimeFormatterMsecs();

    public AudioAnnotation() {
        this(new TimeMsec(), null);
    }

    public AudioAnnotation(TimeMsec timestamp) {
        this(new TimeMsec(), null);
    }

    public AudioAnnotation(TimeMsec timestamp, HashMap<String, Object> metaData) {
        this.m_Timestamp = new TimeMsec(timestamp.getTime());
        this.m_MetaData = null;
        if (metaData != null) {
            this.m_MetaData = new HashMap<String, Object>(metaData);
        }
    }

    public void assign(DataPoint other) {
        super.assign(other);
        AudioAnnotation step = (AudioAnnotation)other;
        this.setTimestamp(step.getTimestamp());
        this.setMetaData(step.getMetaData());
    }

    public void setTimestamp(TimeMsec value) {
        this.m_Timestamp = new TimeMsec(value.getTime());
    }

    public TimeMsec getTimestamp() {
        return this.m_Timestamp;
    }

    public boolean hasMetaData() {
        return this.m_MetaData != null && this.m_MetaData.size() > 0;
    }

    public void setMetaData(HashMap<String, Object> value) {
        this.m_MetaData = value == null ? null : new HashMap<String, Object>(value);
    }

    public HashMap<String, Object> getMetaData() {
        return this.m_MetaData;
    }

    public synchronized void addMetaData(String key, Object value) {
        if (this.m_MetaData == null) {
            this.m_MetaData = new HashMap();
        }
        this.m_MetaData.put(key, value);
    }

    public int compareTo(Object o) {
        AudioAnnotation other = (AudioAnnotation)((Object)o);
        int result = this.getTimestamp().compareTo((Date)other.getTimestamp());
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof AudioAnnotation && this.compareTo(obj) == 0;
    }

    public String toString() {
        return m_DateFormat.format((Date)this.m_Timestamp) + ": meta=" + (this.hasMetaData() ? this.getMetaData().toString() : "");
    }
}

