/*
 * Decompiled with CFR 0.152.
 */
package adams.data.audioannotations;

import adams.core.TimeMsec;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.audioannotations.AudioAnnotation;
import adams.data.audioannotations.AudioAnnotationComparator;
import adams.data.audioannotations.AudioAnnotationsStatistic;
import adams.data.container.AbstractDataContainer;
import adams.data.container.DataContainer;
import adams.data.container.DataPointComparator;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.data.statistics.InformativeStatisticSupporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class AudioAnnotations
extends AbstractDataContainer<AudioAnnotation>
implements MutableReportHandler<Report>,
NotesHandler,
SpreadSheetSupporter,
InformativeStatisticSupporter<AudioAnnotationsStatistic> {
    private static final long serialVersionUID = 8721248965909493612L;
    public static final String PREFIX_META = "Meta-";
    protected Report m_Report;
    protected Notes m_Notes;
    protected static AudioAnnotationComparator m_Comparator;

    public AudioAnnotations() {
        this.m_ID = "" + new Date();
        this.m_Report = new Report();
        this.m_Notes = new Notes();
        if (m_Comparator == null) {
            m_Comparator = this.newComparator();
        }
    }

    public AudioAnnotationComparator newComparator() {
        return new AudioAnnotationComparator();
    }

    public DataPointComparator<AudioAnnotation> getComparator() {
        return m_Comparator;
    }

    public AudioAnnotation newPoint() {
        return new AudioAnnotation();
    }

    public void assign(DataContainer<AudioAnnotation> other) {
        super.assign(other);
        AudioAnnotations trail = (AudioAnnotations)other;
        if (trail.hasReport()) {
            this.setReport(trail.getReport().getClone());
        } else {
            this.setReport(new Report());
        }
        this.m_Notes = new Notes();
        this.m_Notes.mergeWith(trail.getNotes());
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public void setReport(Report value) {
        this.m_Report = value;
    }

    public boolean hasReport() {
        return this.m_Report != null;
    }

    public Report getReport() {
        return this.m_Report;
    }

    public AudioAnnotation getStep(TimeMsec timestamp) {
        AudioAnnotation result = null;
        int pos = Collections.binarySearch(this.m_Points, new AudioAnnotation(timestamp), m_Comparator);
        if (pos >= 0) {
            result = (AudioAnnotation)((Object)this.m_Points.get(pos));
        }
        return result;
    }

    public SpreadSheet toSpreadSheet() {
        HashSet<String> keys = new HashSet<String>();
        for (AudioAnnotation step : this.m_Points) {
            if (!step.hasMetaData()) continue;
            keys.addAll(step.getMetaData().keySet());
        }
        ArrayList keysSorted = new ArrayList(keys);
        Collections.sort(keysSorted);
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.setDataRowClass(DenseDataRow.class);
        result.setName(this.getID());
        HeaderRow row = result.getHeaderRow();
        row.addCell("T").setContent("Timestamp");
        for (String key : keysSorted) {
            row.addCell("M-" + key).setContent(PREFIX_META + key);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AudioAnnotation step;
            step = (AudioAnnotation)((Object)iterator.next());
            row = result.addRow();
            row.addCell("T").setContent(step.getTimestamp());
            if (!step.hasMetaData()) continue;
            for (String key : step.getMetaData().keySet()) {
                row.addCell("M-" + key).setNative(step.getMetaData().get(key));
            }
        }
        return result;
    }

    public AudioAnnotationsStatistic toStatistic() {
        return new AudioAnnotationsStatistic(this);
    }

    public String toString() {
        return "ID=" + this.getID() + ", #points=" + this.size();
    }
}

