/*
 * Decompiled with CFR 0.152.
 */
package adams.data.audioannotations;

import adams.data.audioannotations.AudioAnnotation;
import adams.data.audioannotations.AudioAnnotations;
import adams.data.container.DataContainer;
import adams.data.statistics.AbstractDataStatistic;
import adams.data.statistics.StatUtils;
import java.util.Date;
import java.util.List;

public class AudioAnnotationsStatistic
extends AbstractDataStatistic<AudioAnnotations> {
    private static final long serialVersionUID = -2482267274581297567L;
    public static final String MEDIAN_DELTA_TIMESTAMP = "median delta timestamp";
    public static final String STDEV_DELTA_TIMESTAMP = "stdev delta timestampX";
    public static final String MEAN_DELTA_TIMESTAMP = "mean delta timestamp";
    public static final String MAX_DELTA_TIMESTAMP = "max delta timestamp";
    public static final String MIN_DELTA_TIMESTAMP = "min delta timestamp";
    public static final String LAST_TIMESTAMP = "Last timestamp (msec)";
    public static final String FIRST_TIMESTAMP = "First timestamp (msec)";
    public static final String NUMBER_OF_POINTS = "Number of points";

    public AudioAnnotationsStatistic() {
    }

    public AudioAnnotationsStatistic(AudioAnnotations data) {
        super((DataContainer)data);
    }

    public String globalInfo() {
        return "Calculates a view statistics for an audio trail.";
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Data = null;
    }

    public void setData(AudioAnnotations value) {
        this.m_Calculated = false;
        this.m_Data = value;
    }

    public AudioAnnotations getData() {
        return (AudioAnnotations)this.m_Data;
    }

    public String getStatisticDescription() {
        return ((AudioAnnotations)this.m_Data).getID();
    }

    protected void calculate() {
        super.calculate();
        if (this.m_Data == null) {
            return;
        }
        List points = ((AudioAnnotations)this.m_Data).toList();
        Date firstTimestamp = new Date(0L);
        Date lastTimestamp = new Date(0L);
        Number[] deltaTimestamp = new Long[]{};
        if (points.size() > 0) {
            firstTimestamp = ((AudioAnnotation)((Object)points.get(0))).getTimestamp();
            if (points.size() > 1) {
                lastTimestamp = ((AudioAnnotation)((Object)points.get(points.size() - 1))).getTimestamp();
            }
            deltaTimestamp = new Long[points.size() - 1];
            for (int i = 0; i < points.size(); ++i) {
                if (i <= 0) continue;
                deltaTimestamp[i - 1] = ((AudioAnnotation)((Object)points.get(i))).getTimestamp().getTime() - ((AudioAnnotation)((Object)points.get(i - 1))).getTimestamp().getTime();
            }
        }
        this.add(NUMBER_OF_POINTS, points.size());
        this.add(FIRST_TIMESTAMP, firstTimestamp.getTime());
        this.add(LAST_TIMESTAMP, lastTimestamp.getTime());
        this.add(MIN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.min((Number[])deltaTimestamp)));
        this.add(MAX_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.max((Number[])deltaTimestamp)));
        this.add(MEAN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.mean((Number[])deltaTimestamp)));
        this.add(STDEV_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.stddev((Number[])deltaTimestamp, (boolean)true)));
        this.add(MEDIAN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.median((Number[])deltaTimestamp)));
    }
}

