/*
 * Decompiled with CFR 0.152.
 */
package adams.data.audiofeaturegenerator.wave;

import adams.data.audio.WaveContainer;
import adams.data.audiofeaturegenerator.wave.AbstractWaveFeatureGenerator;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import com.musicg.wave.Wave;
import java.util.ArrayList;
import java.util.List;

public class Fingerprint
extends AbstractWaveFeatureGenerator {
    private static final long serialVersionUID = 1096079057750734103L;

    public String globalInfo() {
        return "Generates a fingerprint from the Wave data.";
    }

    @Override
    public HeaderDefinition createHeader(WaveContainer cont) {
        HeaderDefinition result = new HeaderDefinition();
        byte[] fingerprint = ((Wave)cont.getAudio()).getFingerprint();
        for (int i = 0; i < fingerprint.length; ++i) {
            result.add("FP-" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(WaveContainer cont) {
        List[] result = new List[]{new ArrayList()};
        byte[] fingerprint = ((Wave)cont.getAudio()).getFingerprint();
        for (int i = 0; i < fingerprint.length; ++i) {
            result[0].add(Double.valueOf(fingerprint[i]));
        }
        return result;
    }
}

