/*
 * Decompiled with CFR 0.152.
 */
package adams.data.audiofeaturegenerator.wave;

import adams.data.audio.WaveContainer;
import adams.data.audiofeaturegenerator.wave.AbstractWaveFeatureGenerator;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import adams.data.statistics.StatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Histogram
extends AbstractWaveFeatureGenerator {
    private static final long serialVersionUID = 1096079057750734103L;
    protected ArrayHistogram.BinCalculation m_BinCalculation;
    protected int m_NumBins;
    protected double m_BinWidth;
    protected boolean m_Normalize;
    protected boolean m_UseFixedMinMax;
    protected double m_ManualMin;
    protected double m_ManualMax;
    protected boolean m_DisplayRanges;
    protected int m_NumDecimals;

    public String globalInfo() {
        return "Generates a histogram from the audio data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bin-calc", "binCalculation", (Object)ArrayHistogram.BinCalculation.MANUAL);
        this.m_OptionManager.add("num-bins", "numBins", (Object)50, (Number)1, null);
        this.m_OptionManager.add("bin-width", "binWidth", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("normalize", "normalize", (Object)false);
        this.m_OptionManager.add("use-fixed-min-max", "useFixedMinMax", (Object)false);
        this.m_OptionManager.add("manual-min", "manualMin", (Object)0.0);
        this.m_OptionManager.add("manual-max", "manualMax", (Object)1.0);
        this.m_OptionManager.add("display-ranges", "displayRanges", (Object)false);
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)3, (Number)0, null);
    }

    public void setBinCalculation(ArrayHistogram.BinCalculation value) {
        this.m_BinCalculation = value;
        this.reset();
    }

    public ArrayHistogram.BinCalculation getBinCalculation() {
        return this.m_BinCalculation;
    }

    public String binCalculationTipText() {
        return "Defines how the number of bins are calculated.";
    }

    public void setNumBins(int value) {
        this.m_NumBins = value;
        this.reset();
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use in case of manual bin calculation.";
    }

    public void setBinWidth(double value) {
        this.m_BinWidth = value;
        this.reset();
    }

    public double getBinWidth() {
        return this.m_BinWidth;
    }

    public String binWidthTipText() {
        return "The bin width to use for some of the calculations.";
    }

    public void setNormalize(boolean value) {
        this.m_Normalize = value;
        this.reset();
    }

    public boolean getNormalize() {
        return this.m_Normalize;
    }

    public String normalizeTipText() {
        return "If set to true the data gets normalized first before the histogram is calculated.";
    }

    public void setUseFixedMinMax(boolean value) {
        this.m_UseFixedMinMax = value;
        this.reset();
    }

    public boolean getUseFixedMinMax() {
        return this.m_UseFixedMinMax;
    }

    public String useFixedMinMaxTipText() {
        return "If enabled, then the user-specified min/max values are used for the bin calculation rather than the min/max from the data (allows comparison of histograms when generating histograms over a range of arrays).";
    }

    public void setManualMin(double value) {
        this.m_ManualMin = value;
        this.reset();
    }

    public double getManualMin() {
        return this.m_ManualMin;
    }

    public String manualMinTipText() {
        return "The minimum to use when using manual binning with user-supplied min/max enabled.";
    }

    public void setManualMax(double value) {
        this.m_ManualMax = value;
        this.reset();
    }

    public double getManualMax() {
        return this.m_ManualMax;
    }

    public String manualMaxTipText() {
        return "The maximum to use when using manual binning with user-supplied max/max enabled.";
    }

    public void setDisplayRanges(boolean value) {
        this.m_DisplayRanges = value;
        this.reset();
    }

    public boolean getDisplayRanges() {
        return this.m_DisplayRanges;
    }

    public String displayRangesTipText() {
        return "If enabled, the bins get description according to their range, rather than a simple index.";
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals to show in the bin descriptions.";
    }

    protected ArrayHistogram configure() {
        ArrayHistogram result = new ArrayHistogram();
        result.setBinCalculation(this.m_BinCalculation);
        result.setNumBins(this.m_NumBins);
        result.setBinWidth(this.m_BinWidth);
        result.setNormalize(this.m_Normalize);
        result.setUseFixedMinMax(this.m_UseFixedMinMax);
        result.setManualMin(this.m_ManualMin);
        result.setManualMax(this.m_ManualMax);
        result.setDisplayRanges(this.m_DisplayRanges);
        result.setNumDecimals(this.m_NumDecimals);
        return result;
    }

    @Override
    public HeaderDefinition createHeader(WaveContainer cont) {
        ArrayHistogram histogram = this.configure();
        histogram.add((Serializable[])StatUtils.toNumberArray((byte[])cont.getRawData()));
        AbstractArrayStatistic.StatisticContainer stat = histogram.calculate();
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < stat.getColumnCount(); ++i) {
            result.add(stat.getHeader(i), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(WaveContainer cont) {
        ArrayHistogram histogram = this.configure();
        histogram.add((Serializable[])StatUtils.toNumberArray((byte[])cont.getRawData()));
        AbstractArrayStatistic.StatisticContainer stat = histogram.calculate();
        List[] result = new List[stat.getRowCount()];
        for (int n = 0; n < stat.getRowCount(); ++n) {
            result[n] = new ArrayList();
            for (int i = 0; i < stat.getColumnCount(); ++i) {
                result[n].add(stat.getCell(n, i));
            }
        }
        return result;
    }
}

