/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.image.BufferedImageContainer;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.core.BiColorGenerator;
import com.musicg.wave.extension.Spectrogram;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class SpectrogramToBufferedImage
extends AbstractConversion {
    private static final long serialVersionUID = 6569357563362936237L;
    protected AbstractColorGradientGenerator m_Generator;
    protected transient Color[] m_GradientColors;
    protected transient TIntIntMap m_ColorLookup;

    public String globalInfo() {
        return "Generates an image from the incoming spectrogram.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new BiColorGenerator());
    }

    protected void reset() {
        super.reset();
        this.m_GradientColors = null;
        this.m_ColorLookup = null;
    }

    public void setGenerator(AbstractColorGradientGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractColorGradientGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for creating the gradient colors.";
    }

    public Class accepts() {
        return Spectrogram.class;
    }

    public Class generates() {
        return BufferedImageContainer.class;
    }

    protected Color[] getGradientColors() {
        if (this.m_GradientColors == null) {
            this.m_GradientColors = this.m_Generator.generate();
        }
        return this.m_GradientColors;
    }

    protected TIntIntMap getColorLookup() {
        if (this.m_ColorLookup == null) {
            this.m_ColorLookup = new TIntIntHashMap();
            Color[] colors = this.getGradientColors();
            for (int i = 0; i < colors.length; ++i) {
                this.m_ColorLookup.put(i, colors[i].getRGB());
            }
        }
        return this.m_ColorLookup;
    }

    protected Object doConvert() throws Exception {
        Spectrogram sp = (Spectrogram)this.m_Input;
        double[][] data = sp.getNormalizedSpectrogramData();
        BufferedImageContainer result = new BufferedImageContainer();
        BufferedImage img = new BufferedImage(data.length, data[0].length, 1);
        TIntIntMap colors = this.getColorLookup();
        for (int i = 0; i < data.length; ++i) {
            for (int n = 0; n < data[i].length; ++n) {
                int colorIndex = (int)(data[i][n] * (double)(colors.size() - 1));
                img.setRGB(i, img.getHeight() - n - 1, colors.get(colorIndex));
            }
        }
        result.setImage((Object)img);
        return result;
    }
}

