/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.audio.WaveContainer;
import adams.data.conversion.AbstractConversion;
import com.musicg.wave.Wave;
import gnu.trove.list.array.TDoubleArrayList;

public class WaveToAmplitudes
extends AbstractConversion {
    private static final long serialVersionUID = -4549516743908263051L;
    protected boolean m_Normalized;

    public String globalInfo() {
        return "Extracts the amplitudes from a Wave object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("normalized", "normalized", (Object)false);
    }

    public void setNormalized(boolean value) {
        this.m_Normalized = value;
        this.reset();
    }

    public boolean getNormalized() {
        return this.m_Normalized;
    }

    public String normalizedTipText() {
        return "If enabled, normalized amplitudes are returned rather than absolute ones.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"normalized", (Object)(this.m_Normalized ? "normalized" : "absolute"));
    }

    public Class accepts() {
        return WaveContainer.class;
    }

    public Class generates() {
        return double[].class;
    }

    protected Object doConvert() throws Exception {
        double[] result;
        WaveContainer cont = (WaveContainer)this.m_Input;
        if (this.m_Normalized) {
            result = ((Wave)cont.getAudio()).getNormalizedAmplitudes();
        } else {
            TDoubleArrayList list = new TDoubleArrayList();
            for (short s : ((Wave)cont.getAudio()).getSampleAmplitudes()) {
                list.add((double)s);
            }
            result = list.toArray();
        }
        return result;
    }
}

