/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Properties;
import adams.core.Range;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.data.DateFormatString;
import adams.data.audioannotations.AudioAnnotation;
import adams.data.audioannotations.AudioAnnotations;
import adams.data.container.DataPoint;
import adams.data.io.input.AbstractAudioAnnotationsReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.output.SimpleAudioAnnotationsWriter;
import adams.data.report.Report;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseFloatDataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SimpleAudioAnnotationsReader
extends AbstractAudioAnnotationsReader {
    private static final long serialVersionUID = 1681189490537858223L;

    public String globalInfo() {
        return "Reads audio annotations in simple CSV-like format.\nSee " + SimpleAudioAnnotationsWriter.class.getName() + " for more details on format.";
    }

    public String getFormatDescription() {
        return new SimpleAudioAnnotationsWriter().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new SimpleAudioAnnotationsWriter().getFormatExtensions();
    }

    protected void readData() {
        List lines = FileUtils.loadFromFile((File)this.m_Input.getAbsoluteFile());
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<String> data = new ArrayList<String>();
        boolean header = true;
        for (String line : lines) {
            if (header) {
                if (line.startsWith("# ")) {
                    comments.add(line);
                    continue;
                }
                header = false;
                data.add(line);
                continue;
            }
            data.add(line);
        }
        StringReader sreader = new StringReader(Utils.flatten(data, (String)"\n"));
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setDataRowType((DataRow)new DenseFloatDataRow());
        reader.setComment("#");
        reader.setMissingValue(new BaseRegExp(""));
        reader.setTimeMsecColumns(new Range("first"));
        reader.setTimeMsecLenient(true);
        reader.setTimeMsecFormat(new DateFormatString("HH:mm:ss.SSS"));
        SpreadSheet sheet = reader.read((Reader)sreader);
        if (sheet == null) {
            this.getLogger().severe("Failed to read file from: " + this.m_Input);
            return;
        }
        HashMap<Integer, String> metaCols = new HashMap<Integer, String>();
        for (int i = 0; i < sheet.getColumnNames().size(); ++i) {
            String col = (String)sheet.getColumnNames().get(i);
            if (!col.startsWith("Meta-")) continue;
            metaCols.put(i, col.substring("Meta-".length()));
        }
        Report report = Report.parseProperties((Properties)Properties.fromComment((String)Utils.flatten(comments, (String)"\n")));
        AudioAnnotations trail = new AudioAnnotations();
        for (Row row : sheet.rows()) {
            AudioAnnotation step = new AudioAnnotation(row.getCell(0).toTimeMsec());
            Iterator iterator = metaCols.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (!row.hasCell(n) || row.getCell(n).isMissing()) continue;
                step.addMetaData((String)metaCols.get(n), row.getCell(n).getNative());
            }
            trail.add((DataPoint)step);
        }
        trail.setReport(report);
        this.m_ReadData.add(trail);
    }
}

