/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.data.DateFormatString;
import adams.data.audioannotations.AudioAnnotations;
import adams.data.io.output.AbstractAudioAnnotationsWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class SimpleAudioAnnotationsWriter
extends AbstractAudioAnnotationsWriter {
    private static final long serialVersionUID = -7138302129366743189L;
    public static final String COMMENT = "# ";

    public String globalInfo() {
        return "Writes audio annotations in simple CSV-like format.\nThe report comes before the actual annotation data.\nThe report data is prefixed with '# '.";
    }

    public String getFormatDescription() {
        return "Simple trail format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"aua"};
    }

    public boolean canWriteMultiple() {
        return false;
    }

    protected boolean writeData(List<AudioAnnotations> data) {
        if (data.size() == 0) {
            return false;
        }
        AudioAnnotations trail = data.get(0);
        StringWriter swriter = new StringWriter();
        if (trail.hasReport()) {
            Properties props = trail.getReport().toProperties();
            swriter.write(props.toComment());
        }
        SpreadSheet sheet = trail.toSpreadSheet();
        CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
        writer.setTimeMsecFormat(new DateFormatString("HH:mm:ss.SSS"));
        writer.setMissingValue("");
        boolean result = writer.write(sheet, (Writer)swriter);
        if (result) {
            result = FileUtils.writeToFile((String)this.m_Output.getAbsolutePath(), (Object)swriter.toString(), (boolean)false);
        }
        return result;
    }
}

