/*
 * Decompiled with CFR 0.152.
 */
package adams.data.wavefilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.InPlaceProcessing;
import adams.data.audio.WaveContainer;
import adams.data.wavefilter.AbstractWaveFilter;
import adams.data.wavefilter.WaveIndexingType;
import com.musicg.wave.Wave;

public class Cut
extends AbstractWaveFilter
implements InPlaceProcessing {
    private static final long serialVersionUID = 2319957467336388607L;
    protected WaveIndexingType m_Type;
    protected double m_Start;
    protected double m_Duration;
    protected boolean m_NoCopy;

    public String globalInfo() {
        return "Cuts out the specified section from the Wave object.\nOnly works if 'subChunk2Id' is 'data' not 'LIST'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)WaveIndexingType.SAMPLES);
        this.m_OptionManager.add("start", "start", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("duration", "duration", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("no-copy", "noCopy", (Object)false);
    }

    public void setType(WaveIndexingType value) {
        this.m_Type = value;
        this.reset();
    }

    public WaveIndexingType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "How to interpret the start/duration values.";
    }

    public void setStart(double value) {
        this.m_Start = value;
        this.reset();
    }

    public double getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The starting point for the cut.";
    }

    public void setDuration(double value) {
        this.m_Duration = value;
        this.reset();
    }

    public double getDuration() {
        return this.m_Duration;
    }

    public String durationTipText() {
        return "The duration of the cut.";
    }

    public void setNoCopy(boolean value) {
        this.m_NoCopy = value;
        this.reset();
    }

    public boolean getNoCopy() {
        return this.m_NoCopy;
    }

    public String noCopyTipText() {
        return "If enabled, no copy of the Wave is created before cutting.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"start", (Object)this.m_Start, (String)", start: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"duration", (Object)this.m_Duration, (String)", duration: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no-copy", (String)", ");
        return result;
    }

    @Override
    protected WaveContainer processData(WaveContainer data) {
        WaveContainer result = !this.m_NoCopy ? (WaveContainer)data.getClone() : data;
        switch (this.m_Type) {
            case SAMPLES: {
                ((Wave)result.getAudio()).trim((int)this.m_Start, (int)((double)((Wave)result.getAudio()).getWaveHeader().getSubChunk2Size() - this.m_Duration - this.m_Start));
                break;
            }
            case SECONDS: {
                ((Wave)result.getAudio()).trim(this.m_Start, (double)((Wave)result.getAudio()).getLengthInSeconds() - this.m_Duration - this.m_Start);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled cut type: " + (Object)((Object)this.m_Type));
            }
        }
        return result;
    }
}

