/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.source.audiorecorder.AbstractAudioRecorder;
import adams.flow.source.audiorecorder.FixedDuration;

public class AudioRecorder
extends AbstractSimpleSource {
    private static final long serialVersionUID = 2371595714506506149L;
    protected AbstractAudioRecorder m_Recorder;

    public String globalInfo() {
        return "Records audio using the specified recording scheme.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("recorder", "recorder", (Object)new FixedDuration());
    }

    public void setRecorder(AbstractAudioRecorder value) {
        this.m_Recorder = value;
        this.reset();
    }

    public AbstractAudioRecorder getRecorder() {
        return this.m_Recorder;
    }

    public String recorderTipText() {
        return "The recorder scheme to use for recording the audio.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"recorder", (Object)((Object)this.m_Recorder), (String)"recorder: ");
    }

    public Class[] generates() {
        return new Class[]{this.m_Recorder.generates()};
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Recorder.setFlowContext((Actor)this);
            Object output = this.m_Recorder.record();
            if (output == null) {
                result = "No output generated!";
            } else {
                this.m_OutputToken = new Token(output);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to record!", e);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Recorder != null) {
            this.m_Recorder.stopExecution();
        }
        super.stopExecution();
    }
}

