/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.audiorecorder;

import adams.core.QuickInfoHelper;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.RunnableWithLogging;
import adams.flow.source.audiorecorder.AbstractAudioRecorder;
import java.util.logging.Level;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public abstract class AbstractFileBasedAudioRecorder
extends AbstractAudioRecorder<String>
implements FileWriter {
    private static final long serialVersionUID = 4890769027613827691L;
    protected PlaceholderFile m_OutputFile;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-file", "outputFile", (Object)this.getDefaultOutputFile());
    }

    protected abstract PlaceholderFile getDefaultOutputFile();

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public abstract String outputFileTipText();

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)", output: ");
        return result;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    protected RunnableWithLogging getRecordingWorker(final DataLine.Info info, final AudioFormat format, final AudioFileFormat.Type type) {
        RunnableWithLogging result = new RunnableWithLogging(){
            protected TargetDataLine microphone;

            protected void doRun() {
                try {
                    this.microphone = (TargetDataLine)AudioSystem.getLine(info);
                    this.microphone.open(format);
                    this.microphone.start();
                    AudioInputStream ais = new AudioInputStream(this.microphone);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Recording type " + type + " to: " + AbstractFileBasedAudioRecorder.this.m_OutputFile);
                    }
                    if (!this.isStopped() && this.microphone.isOpen()) {
                        AudioSystem.write(ais, type, AbstractFileBasedAudioRecorder.this.m_OutputFile.getAbsoluteFile());
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to record!", (Throwable)e);
                }
            }

            public void stopExecution() {
                this.microphone.stop();
                this.microphone.close();
                super.stopExecution();
            }
        };
        result.setLoggingLevel(this.getLoggingLevel());
        return result;
    }

    protected abstract String doRecordTo(PlaceholderFile var1);

    @Override
    protected String doRecord() {
        String msg = this.doRecordTo(this.m_OutputFile);
        if (msg != null) {
            throw new IllegalStateException("Failed to record to '" + this.m_OutputFile + "': " + msg);
        }
        if (this.isStopped()) {
            return null;
        }
        return this.m_OutputFile.getAbsolutePath();
    }
}

