/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.audiorecorder;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.flow.core.RunnableWithLogging;
import adams.flow.source.audiorecorder.AbstractFileBasedAudioRecorder;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;

public class OnDemand
extends AbstractFileBasedAudioRecorder {
    private static final long serialVersionUID = 8545013784919517494L;
    protected RunnableWithLogging m_Recording;
    protected RunnableWithLogging m_Monitor;

    public String globalInfo() {
        return "Records a WAV file from when the user starts recording to when the user ends it.";
    }

    @Override
    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile("${TMP}/out.wav");
    }

    @Override
    public String outputFileTipText() {
        return "The WAV file to record the audio data to.";
    }

    @Override
    public boolean requiresFlowContext() {
        return true;
    }

    protected RunnableWithLogging getRecordingWorker(DataLine.Info info, AudioFormat format) {
        return this.getRecordingWorker(info, format, AudioFileFormat.Type.WAVE);
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null && this.getFlowContext().isHeadless()) {
            result = "Cannot operate in headless environment!";
        }
        return result;
    }

    @Override
    protected String doRecordTo(PlaceholderFile output) {
        MessageCollection errors = new MessageCollection();
        final AudioFormat format = this.getAudioFormat();
        final DataLine.Info info = this.getDataLineInfo(format, errors);
        if (!errors.isEmpty()) {
            return errors.toString();
        }
        int retVal = GUIHelper.showConfirmMessage((Component)this.getFlowContext().getParentComponent(), (String)"Start recording");
        if (retVal != 0) {
            return "User canceled dialog!";
        }
        this.m_Monitor = new RunnableWithLogging(){

            protected void doRun() {
                OnDemand.this.m_Recording = OnDemand.this.getRecordingWorker(info, format);
                new Thread((Runnable)OnDemand.this.m_Recording).start();
                while (!this.isStopped()) {
                    Utils.wait((LoggingSupporter)this, (int)1000, (int)100);
                }
                OnDemand.this.m_Recording = null;
                OnDemand.this.m_Monitor = null;
            }

            public void stopExecution() {
                if (OnDemand.this.m_Recording != null) {
                    OnDemand.this.m_Recording.stopExecution();
                }
                super.stopExecution();
            }
        };
        new Thread((Runnable)this.m_Monitor).start();
        while ((retVal = GUIHelper.showConfirmMessage((Component)this.getFlowContext().getParentComponent(), (String)"Stop recording")) != 0) {
        }
        this.m_Monitor.stopExecution();
        while (!this.isStopped() && this.m_Monitor != null) {
            Utils.wait((LoggingSupporter)this, (int)1000, (int)100);
        }
        return null;
    }

    @Override
    public void stopExecution() {
        if (this.m_Monitor != null) {
            this.m_Monitor.stopExecution();
        }
        super.stopExecution();
    }
}

