/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.TimeMsec;
import adams.core.base.BaseDateTimeMsec;
import adams.core.base.BaseKeyValuePair;
import adams.core.option.OptionHandler;
import adams.data.audioannotations.AudioAnnotation;
import adams.data.audioannotations.AudioAnnotations;
import adams.data.container.DataPoint;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class AddAudioAnnotation
extends AbstractTransformer {
    private static final long serialVersionUID = 3690378527551302472L;
    protected BaseDateTimeMsec m_Timestamp;
    protected BaseKeyValuePair[] m_MetaData;

    public String globalInfo() {
        return "Adds an annotation to the audio annotations passing through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new BaseDateTimeMsec());
        this.m_OptionManager.add("meta-data", "metaData", (Object)new BaseKeyValuePair[0]);
    }

    public void setTimestamp(BaseDateTimeMsec value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public BaseDateTimeMsec getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The timestamp of the step to add.";
    }

    public void setMetaData(BaseKeyValuePair[] value) {
        this.m_MetaData = value;
        this.reset();
    }

    public BaseKeyValuePair[] getMetaData() {
        return this.m_MetaData;
    }

    public String metaDataTipText() {
        return "The (optional) meta-data to attached to the step.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"timestamp", (Object)this.m_Timestamp, (String)"timestamp: ");
    }

    public Class[] accepts() {
        return new Class[]{AudioAnnotations.class};
    }

    public Class[] generates() {
        return new Class[]{AudioAnnotations.class};
    }

    protected String doExecute() {
        AudioAnnotations trail = (AudioAnnotations)((Object)this.m_InputToken.getPayload());
        AudioAnnotation step = new AudioAnnotation(new TimeMsec(this.m_Timestamp.dateValue()));
        for (BaseKeyValuePair pair : this.m_MetaData) {
            step.addMetaData(pair.getPairKey(), pair.getPairValue());
        }
        trail.add((DataPoint)step);
        this.m_OutputToken = new Token((Object)trail);
        return null;
    }
}

