/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.audiodata;

import adams.core.Utils;
import adams.core.base.BaseURL;
import adams.core.io.FileUtils;
import adams.data.audio.WaveContainer;
import adams.flow.transformer.audiodata.AbstractAudioDataReader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class Wave
extends AbstractAudioDataReader<WaveContainer> {
    private static final long serialVersionUID = -8099230864926096497L;

    public String globalInfo() {
        return "Reads data from WAV files or URLs.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, URL.class, BaseURL.class};
    }

    @Override
    public Class generates() {
        return WaveContainer.class;
    }

    @Override
    protected WaveContainer doRead(Object input) throws Exception {
        BufferedInputStream is = null;
        if (input instanceof String) {
            is = new BufferedInputStream(new FileInputStream((String)input));
        } else if (input instanceof URL) {
            is = new BufferedInputStream(((URL)input).openStream());
        } else if (input instanceof BaseURL) {
            is = new BufferedInputStream(((BaseURL)input).urlValue().openStream());
        }
        if (is != null) {
            com.musicg.wave.Wave wave = new com.musicg.wave.Wave((InputStream)is);
            WaveContainer result = new WaveContainer();
            result.setAudio(wave);
            FileUtils.closeQuietly((InputStream)is);
            if (input instanceof String) {
                result.getReport().setStringValue("File", input.toString());
            } else {
                result.getReport().setStringValue("URL", input.toString());
            }
            adams.flow.transformer.audioinfo.Wave reader = new adams.flow.transformer.audioinfo.Wave();
            Map<String, Object> info = reader.read(wave);
            for (String key : info.keySet()) {
                Object value = info.get(key);
                if (value instanceof Boolean) {
                    result.getReport().setBooleanValue(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Number) {
                    result.getReport().setNumericValue(key, ((Number)value).doubleValue());
                    continue;
                }
                result.getReport().setStringValue(key, value.toString());
            }
            return result;
        }
        throw new IllegalStateException("Unhandled input data: " + Utils.classToString((Object)input));
    }
}

