/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.audioinfo;

import adams.core.License;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.flow.transformer.audioinfo.AbstractAudioInfoReader;
import com.mpatric.mp3agic.ID3v1;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.Mp3File;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@MixedCopyright(author="Michael Patricios", url="https://raw.githubusercontent.com/mpatric/mp3agic-examples/master/src/main/java/com/mpatric/mp3agic/app/Mp3Details.java", license=License.MIT)
public class MP3
extends AbstractAudioInfoReader {
    private static final long serialVersionUID = 568010617982277726L;

    public String globalInfo() {
        return "Outputs information on the incoming MP3 file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, Mp3File.class};
    }

    protected String formatTime(long seconds) {
        return Long.toString(seconds / 60L) + ":" + String.format("%02d", seconds % 60L);
    }

    protected Map<String, Object> getMp3Fields(Mp3File mp3file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.showField(result, "Filename", new File(mp3file.getFilename()).getName());
        this.showField(result, "Size", Long.toString(mp3file.getLength()));
        this.showField(result, "Length", this.formatTime(mp3file.getLengthInSeconds()));
        this.showField(result, "Version", mp3file.getVersion());
        this.showField(result, "Layer", mp3file.getLayer());
        this.showField(result, "Sample rate", Integer.toString(mp3file.getSampleRate()), "Hz");
        this.showField(result, "Bitrate", Integer.toString(mp3file.getBitrate()), "kbps (" + this.vbrString(mp3file.isVbr()) + ")");
        this.showField(result, "Channel mode", mp3file.getChannelMode());
        return result;
    }

    protected String vbrString(boolean vbr) {
        if (vbr) {
            return "VBR";
        }
        return "CBR";
    }

    protected Map<String, Object> getId3v1Fields(Mp3File mp3file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ID3v1 id3v1tag = mp3file.getId3v1Tag();
        if (id3v1tag != null) {
            this.showField(result, "Track", id3v1tag.getTrack());
            this.showField(result, "Artist", id3v1tag.getArtist());
            this.showField(result, "Title", id3v1tag.getTitle());
            this.showField(result, "Album", id3v1tag.getAlbum());
            this.showField(result, "Year", id3v1tag.getYear());
            this.showField(result, "Genre", id3v1tag.getGenreDescription());
            this.showField(result, "Comment", id3v1tag.getComment());
        }
        return result;
    }

    protected Map<String, Object> getId3v2Fields(Mp3File mp3file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ID3v2 id3v2tag = mp3file.getId3v2Tag();
        if (id3v2tag != null) {
            this.showField(result, "Track", id3v2tag.getTrack());
            this.showField(result, "Artist", id3v2tag.getArtist());
            this.showField(result, "Album", id3v2tag.getAlbum());
            this.showField(result, "Title", id3v2tag.getTitle());
            this.showField(result, "Year", id3v2tag.getYear());
            this.showField(result, "Genre", id3v2tag.getGenreDescription());
            this.showField(result, "Comment", id3v2tag.getComment());
            this.showField(result, "Composer", id3v2tag.getComposer());
            this.showField(result, "Original Artist", id3v2tag.getOriginalArtist());
            this.showField(result, "Copyright", id3v2tag.getCopyright());
            this.showField(result, "Url", id3v2tag.getUrl());
            this.showField(result, "Encoder", id3v2tag.getEncoder());
            this.showField(result, "Album Image", id3v2tag.getAlbumImageMimeType());
        }
        return result;
    }

    protected void showField(Map<String, Object> info, String name, String field) {
        this.showField(info, name, field, false, null);
    }

    protected void showField(Map<String, Object> info, String name, String field, String units) {
        this.showField(info, name, field, false, units);
    }

    protected void showField(Map<String, Object> info, String name, String field, boolean last, String units) {
        info.put(name, field + (units != null ? units : ""));
    }

    @Override
    protected Map<String, Object> doRead(Object input) throws Exception {
        Mp3File mp3;
        if (input instanceof String) {
            mp3 = new Mp3File((String)input);
        } else if (input instanceof Mp3File) {
            mp3 = (Mp3File)input;
        } else {
            throw new IllegalStateException("Unhandled input data: " + Utils.classToString((Object)input));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.getMp3Fields(mp3));
        result.putAll(this.getId3v1Fields(mp3));
        result.putAll(this.getId3v2Fields(mp3));
        return result;
    }
}

