/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.audio;

import adams.core.CleanUpHandler;
import adams.core.Utils;
import adams.gui.chooser.AudioFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AudioPlaybackPanel
extends BasePanel
implements CleanUpHandler,
LineListener {
    private static final long serialVersionUID = 3226494650794473459L;
    public static final String NO_TIME = "--:--:--";
    protected BaseButton m_ButtonStart;
    protected BaseButton m_ButtonPauseResume;
    protected BaseButton m_ButtonStop;
    protected JLabel m_LabelTime;
    protected JSlider m_Slider;
    protected boolean m_Playing;
    protected boolean m_Paused;
    protected File m_CurrentFile;
    protected transient Clip m_Clip;
    protected AudioFileChooser m_FileChooser;
    protected Timer m_RefreshTimer;

    protected void initialize() {
        super.initialize();
        this.m_Playing = false;
        this.m_Paused = false;
        this.m_CurrentFile = null;
        this.m_Clip = null;
        this.m_FileChooser = new AudioFileChooser();
        this.m_RefreshTimer = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Slider = new JSlider();
        this.m_Slider.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Slider.setMinimum(0);
        this.m_Slider.addChangeListener(e -> {
            if (this.m_Slider.getValueIsAdjusting()) {
                if (this.m_Clip.isRunning()) {
                    this.m_Clip.stop();
                }
                this.m_Clip.setMicrosecondPosition(this.m_Slider.getValue() * 1000);
            } else if (this.m_Clip != null && !this.m_Clip.isRunning()) {
                this.m_Clip.setMicrosecondPosition(this.m_Slider.getValue() * 1000);
                if (!this.isPaused()) {
                    this.m_Clip.start();
                }
            }
            this.updateTime(false);
        });
        this.add(this.m_Slider, "North");
        this.m_LabelTime = new JLabel(NO_TIME);
        this.m_LabelTime.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_LabelTime.setFont(this.m_LabelTime.getFont().deriveFont((float)this.m_LabelTime.getFont().getSize() * 2.0f));
        this.add(this.m_LabelTime, "Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add(panel, "South");
        this.m_ButtonStart = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
        this.m_ButtonStart.addActionListener(e -> this.start());
        panel.add((Component)this.m_ButtonStart);
        this.m_ButtonPauseResume = new BaseButton((Icon)GUIHelper.getIcon((String)"pause.gif"));
        this.m_ButtonPauseResume.addActionListener(e -> this.pauseOrResume());
        panel.add((Component)this.m_ButtonPauseResume);
        this.m_ButtonStop = new BaseButton((Icon)GUIHelper.getIcon((String)"stop_blue.gif"));
        this.m_ButtonStop.addActionListener(e -> this.stop());
        panel.add((Component)this.m_ButtonStop);
    }

    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    public boolean open() {
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return false;
        }
        this.open(this.m_FileChooser.getSelectedFile());
        return true;
    }

    public void open(File file) {
        this.stop();
        this.m_CurrentFile = file;
        this.update();
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public void start() {
        if (this.m_CurrentFile == null) {
            return;
        }
        if (this.m_Clip != null) {
            return;
        }
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(this.getCurrentFile().getAbsoluteFile());
            AudioFormat format = ais.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.m_Clip = (Clip)AudioSystem.getLine(info);
            this.m_Clip.addLineListener(this);
            this.m_Clip.open(ais);
            this.m_RefreshTimer = new Timer(200, e -> this.updateTime(true));
            this.m_Playing = true;
            this.m_Paused = false;
            this.m_Slider.setMinimum(0);
            this.m_Slider.setMaximum((int)(this.m_Clip.getMicrosecondLength() / 1000L));
            this.m_Clip.start();
            this.m_Slider.setValue(0);
        }
        catch (Exception e2) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to playback file: " + this.getCurrentFile()), (Throwable)e2);
            this.m_Clip = null;
        }
        this.update();
    }

    public void pauseOrResume() {
        if (this.m_Clip == null) {
            return;
        }
        if (this.isPaused()) {
            this.m_Clip.start();
            this.m_ButtonPauseResume.setIcon((Icon)GUIHelper.getIcon((String)"pause.gif"));
        } else {
            this.m_Clip.stop();
            this.m_ButtonPauseResume.setIcon((Icon)GUIHelper.getIcon((String)"resume.gif"));
        }
        this.m_Paused = !this.m_Paused;
        this.update();
    }

    public void stop() {
        this.m_Playing = false;
        this.m_Paused = false;
        if (this.m_Clip != null) {
            this.m_Clip.removeLineListener(this);
            this.m_Clip.close();
            this.m_Clip = null;
        }
        if (this.m_RefreshTimer != null) {
            this.m_RefreshTimer.stop();
            this.m_RefreshTimer = null;
        }
        this.m_ButtonPauseResume.setIcon((Icon)GUIHelper.getIcon((String)"pause.gif"));
        this.resetTime();
        this.updateButtons();
    }

    public boolean isPlaying() {
        return this.m_Playing;
    }

    public boolean isPaused() {
        return this.m_Paused;
    }

    public long getTimestamp() {
        if (this.m_Clip != null) {
            return this.m_Clip.getMicrosecondPosition() / 1000L;
        }
        return -1L;
    }

    protected void resetTime() {
        this.m_Slider.setValue(0);
        this.m_LabelTime.setText(NO_TIME);
    }

    protected void updateTime(boolean updateSlider) {
        if (this.m_Clip != null) {
            int current = (int)this.m_Clip.getMicrosecondPosition() / 1000;
            int time = current / 1000;
            int hours = time / 3600;
            int mins = (time %= 3600) / 60;
            int secs = time % 60;
            int msecs = current % 1000;
            if (updateSlider) {
                SwingUtilities.invokeLater(() -> this.m_Slider.setValue(current));
            }
            SwingUtilities.invokeLater(() -> this.m_LabelTime.setText(Utils.padLeft((String)("" + hours), (char)'0', (int)2) + ":" + Utils.padLeft((String)("" + mins), (char)'0', (int)2) + ":" + Utils.padLeft((String)("" + secs), (char)'0', (int)2) + "." + Utils.padLeft((String)("" + msecs), (char)'0', (int)3)));
        }
    }

    protected void updateButtons() {
        boolean fileLoaded = this.getCurrentFile() != null;
        this.m_ButtonStart.setEnabled(fileLoaded && !this.isPlaying());
        this.m_ButtonPauseResume.setEnabled(fileLoaded && this.isPlaying());
        this.m_ButtonStop.setEnabled(fileLoaded && this.isPlaying());
    }

    protected void update() {
        this.updateTime(true);
        this.updateButtons();
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.START) {
            if (this.m_RefreshTimer != null) {
                this.m_RefreshTimer.start();
            }
        } else if (event.getType() == LineEvent.Type.STOP) {
            if (this.m_RefreshTimer != null) {
                this.m_RefreshTimer.stop();
            }
            if (this.m_Clip.getMicrosecondLength() == this.m_Clip.getMicrosecondPosition()) {
                this.stop();
            } else {
                this.update();
            }
        }
    }

    public void cleanUp() {
        this.stop();
    }
}

