/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.audioannotator;

import adams.core.TimeMsec;
import adams.data.audioannotations.AudioAnnotation;
import adams.gui.action.AbstractBaseAction;
import adams.gui.audio.AudioPlaybackPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.tools.audioannotator.AnnotationEvent;
import adams.gui.tools.audioannotator.AnnotationListener;
import adams.gui.tools.audioannotator.Binding;
import adams.gui.tools.audioannotator.TickEvent;
import adams.gui.tools.audioannotator.TickListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AudioAnnotationPanel
extends BasePanel
implements TickListener {
    private static final long serialVersionUID = -8145795884307782157L;
    public static final int BORDER_THICKNESS = 5;
    public static final Color OFF_COLOUR = Color.RED;
    public static final Color ON_COLOUR = Color.GREEN;
    protected List<AnnotationListener> m_Listeners;
    protected Binding m_Binding;
    protected AudioPlaybackPanel m_Player;
    protected AbstractBaseAction m_Action;
    protected long m_Interval;
    protected boolean m_IsToggleable;
    protected boolean m_IsToggled;
    protected BaseButton m_Button;

    public void configureAnnotationPanel(Binding binding, AudioPlaybackPanel player) {
        this.m_Binding = binding;
        this.m_Player = player;
        this.m_Interval = binding.getInterval();
        this.m_IsToggleable = binding.isToggleable();
        this.addKeyBinding(this.m_Binding);
    }

    protected void makeStep(TimeMsec timestamp) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        if (this.m_IsToggleable) {
            meta.put(this.m_Binding.getName(), this.m_Binding.isInverted() ^ this.m_IsToggled);
        } else {
            meta.put(this.m_Binding.getName(), !this.m_Binding.isInverted());
        }
        AudioAnnotation annotation = new AudioAnnotation(timestamp, meta);
        this.notifyListeners(annotation);
    }

    protected void initialize() {
        super.initialize();
        this.m_IsToggled = false;
        this.m_Listeners = new ArrayList<AnnotationListener>();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new FlowLayout(1));
        this.m_Button = new BaseButton();
        this.add((Component)this.m_Button);
    }

    protected void finishInit() {
        super.finishInit();
    }

    public void addListener(AnnotationListener listener) {
        if (this.m_Listeners.contains(listener)) {
            return;
        }
        this.m_Listeners.add(listener);
    }

    protected AbstractBaseAction addKeyBinding(Binding binding) {
        KeyStroke keyStroke = binding.getBinding();
        if (this.m_IsToggleable) {
            this.setBorder(new LineBorder(OFF_COLOUR, 5));
            this.m_Action = new AbstractBaseAction(binding.getName() + " (" + binding.getBinding() + ")"){

                protected void doActionPerformed(ActionEvent e) {
                    boolean bl = AudioAnnotationPanel.this.m_IsToggled = !AudioAnnotationPanel.this.m_IsToggled;
                    if (AudioAnnotationPanel.this.m_IsToggled) {
                        Runnable run = () -> {
                            AudioAnnotationPanel.this.setBorder(new LineBorder(ON_COLOUR, 5));
                            AudioAnnotationPanel.this.revalidate();
                        };
                        SwingUtilities.invokeLater(run);
                    } else {
                        Runnable run = () -> {
                            AudioAnnotationPanel.this.setBorder(new LineBorder(OFF_COLOUR, 5));
                            AudioAnnotationPanel.this.revalidate();
                        };
                        SwingUtilities.invokeLater(run);
                    }
                }
            };
        } else {
            this.setBorder(new LineBorder(this.getBackground(), 5));
            this.m_Action = new AbstractBaseAction(binding.getName() + " (" + binding.getBinding() + ")"){

                protected void doActionPerformed(ActionEvent e) {
                    TimeMsec timestamp = new TimeMsec(AudioAnnotationPanel.this.m_Player.getTimestamp());
                    AudioAnnotationPanel.this.makeStep(timestamp);
                }
            };
        }
        this.m_Button.setAction((Action)this.m_Action);
        this.getInputMap(2).put(keyStroke, binding.getName());
        this.getActionMap().put(binding.getName(), (Action)this.m_Action);
        return this.m_Action;
    }

    protected void notifyListeners(AudioAnnotation annotation) {
        if (this.m_Listeners == null) {
            return;
        }
        AnnotationEvent e = new AnnotationEvent(this, annotation);
        for (AnnotationListener listener : this.m_Listeners) {
            listener.annotationOccurred(e);
        }
    }

    @Override
    public void tickHappened(TickEvent e) {
        this.makeStep(e.getTimeStamp());
    }

    @Override
    public long getInterval() {
        return this.m_Interval;
    }
}

