/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.audioannotator;

import adams.core.CleanUpHandler;
import adams.core.DateFormat;
import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.data.audioannotations.AudioAnnotations;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractAudioAnnotationsReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.action.AbstractBaseAction;
import adams.gui.audio.AudioPlaybackPanel;
import adams.gui.chooser.AudioAnnotationsFileChooser;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.tools.audioannotator.AudioAnnotationPanel;
import adams.gui.tools.audioannotator.Binding;
import adams.gui.tools.audioannotator.EditBindingsDialog;
import adams.gui.tools.audioannotator.EventQueue;
import adams.gui.tools.audioannotator.Ticker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class AudioAnnotatorPanel
extends BasePanel
implements MenuBarProvider,
CleanUpHandler {
    private static final long serialVersionUID = 6965340882268141821L;
    public static final String AUDIO_SESSION_FILE = "AudioAnnotatorAudioSession.props";
    public static final String BINDINGS_SESSION_FILE = "AudioAnnotatorBindingSession.props";
    public static final String ANNOTATION_SESSION_FILE = "AudioAnnotatorAnnotationSession.props";
    protected List<Binding> m_Bindings;
    protected TitleGenerator m_TitleGenerator;
    protected AudioPlaybackPanel m_Player;
    protected BasePanel m_BindingPanel;
    protected EditBindingsDialog m_BindingsDialog;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemAudioOpen;
    protected RecentFilesHandler<JMenu> m_RecentAudioFilesHandler;
    protected JMenu m_MenuFileLoadRecentAudioFiles;
    protected RecentFilesHandler<JMenu> m_RecentAnnotationsHandler;
    protected JMenu m_MenuAnnotationLoadRecentAnnotations;
    protected JMenuItem m_MenuItemFileClose;
    protected AbstractBaseAction m_ActionPlay;
    protected AbstractBaseAction m_ActionPause;
    protected AbstractBaseAction m_ActionStop;
    protected AbstractBaseAction m_ActionNewBindings;
    protected AbstractBaseAction m_ActionEditBindings;
    protected AbstractBaseAction m_ActionNewAnnotations;
    protected AbstractBaseAction m_ActionOpenAnnotations;
    protected JMenuItem m_MenuItemAnnotationsOpen;
    protected AbstractBaseAction m_ActionSaveAnnotations;
    protected AbstractBaseAction m_ActionExtractBackground;
    protected AbstractBaseAction m_ActionExportAnnotations;
    protected AbstractBaseAction m_ActionSaveBindings;
    protected AbstractBaseAction m_ActionLoadBindings;
    protected DateFormat m_dateFormatter;
    protected SpreadSheetFileChooser m_ExportFileChooser;
    protected BaseFileChooser m_SavePropertiesFileChooser;
    protected BaseFileChooser m_LoadPropertiesFileChooser;
    protected EventQueue m_EventQueue;
    protected RecentFilesHandler<JMenu> m_RecentBindingsHandler;
    protected JMenu m_MenuFileLoadRecentBindings;
    protected Ticker m_Ticker;
    protected AudioAnnotationsFileChooser m_AnnotationsFileChooser;

    protected void initialize() {
        super.initialize();
        this.m_TitleGenerator = new TitleGenerator("Annotator", true);
        this.m_dateFormatter = new DateFormat("HH:mm:ss");
        this.m_Bindings = new ArrayList<Binding>();
        this.m_ExportFileChooser = new SpreadSheetFileChooser();
        this.m_SavePropertiesFileChooser = new BaseFileChooser();
        this.m_AnnotationsFileChooser = new AudioAnnotationsFileChooser();
        this.m_LoadPropertiesFileChooser = new BaseFileChooser();
        this.m_SavePropertiesFileChooser.setAcceptAllFileFilterUsed(false);
        this.m_SavePropertiesFileChooser.setAutoAppendExtension(true);
        this.m_SavePropertiesFileChooser.addChoosableFileFilter((FileFilter)ExtensionFileFilter.getPropertiesFileFilter());
        this.m_SavePropertiesFileChooser.setDefaultExtension("props");
        this.m_LoadPropertiesFileChooser.setAcceptAllFileFilterUsed(false);
        this.m_LoadPropertiesFileChooser.setAutoAppendExtension(true);
        this.m_LoadPropertiesFileChooser.addChoosableFileFilter((FileFilter)ExtensionFileFilter.getPropertiesFileFilter());
        this.m_LoadPropertiesFileChooser.setDefaultExtension("props");
        this.m_EventQueue = new EventQueue();
        this.initActions();
    }

    protected void initActions() {
        AbstractBaseAction action = new AbstractBaseAction("Play", "run.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.m_Player.start();
            }
        };
        action.setMnemonic(80);
        action.setAccelerator("ctrl pressed P");
        this.m_ActionPlay = action;
        action = new AbstractBaseAction("Pause", "pause.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.m_Player.pauseOrResume();
            }
        };
        action.setMnemonic(85);
        action.setAccelerator("ctrl pressed U");
        this.m_ActionPause = action;
        action = new AbstractBaseAction("Stop", "stop_blue.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.m_Player.stop();
            }
        };
        action.setMnemonic(83);
        action.setAccelerator("ctrl pressed S");
        this.m_ActionStop = action;
        this.m_ActionNewBindings = action = new AbstractBaseAction("New", "new.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.newBindings();
            }
        };
        this.m_ActionEditBindings = action = new AbstractBaseAction("Edit...", "properties.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.editBindings();
            }
        };
        this.m_ActionExportAnnotations = action = new AbstractBaseAction("Export...", "spreadsheet.png"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.export();
            }
        };
        this.m_ActionSaveBindings = action = new AbstractBaseAction("Save as...", "save.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.saveBindings();
            }
        };
        this.m_ActionLoadBindings = action = new AbstractBaseAction("Open...", "open.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.loadBindings();
            }
        };
        this.m_ActionNewAnnotations = action = new AbstractBaseAction("New", "new.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.m_EventQueue.resetAnnotations();
            }
        };
        this.m_ActionOpenAnnotations = action = new AbstractBaseAction("Open...", "open.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.openAnnotations();
            }
        };
        this.m_ActionSaveAnnotations = action = new AbstractBaseAction("Save As...", "save.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AudioAnnotatorPanel.this.saveAnnotations();
            }
        };
    }

    protected void initGUI() {
        super.initGUI();
        this.m_Player = new AudioPlaybackPanel();
        this.m_BindingPanel = new BasePanel((LayoutManager)new FlowLayout());
        this.m_Ticker = new Ticker(this.m_Player);
        this.add((Component)((Object)this.m_Player), "Center");
        this.add((Component)this.m_BindingPanel, "South");
    }

    protected void finishInit() {
        super.finishInit();
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("Audio");
            result.add(menu);
            menu.setMnemonic('A');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("Open...", GUIHelper.getIcon((String)"open.gif"));
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.addActionListener(e -> {
                if (this.m_Player.open()) {
                    this.m_EventQueue.resetAnnotations();
                    if (this.m_RecentAudioFilesHandler != null) {
                        this.m_RecentAudioFilesHandler.addRecentItem((Object)this.m_Player.getCurrentFile());
                    }
                    this.revalidate();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemAudioOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentAudioFilesHandler = new RecentFilesHandler(AUDIO_SESSION_FILE, 5, (Object)submenu);
            this.m_RecentAudioFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AudioAnnotatorPanel.this.m_Player.open((File)e.getItem());
                }
            });
            this.m_MenuFileLoadRecentAudioFiles = submenu;
            menuitem = new JMenuItem("Quit", GUIHelper.getIcon((String)"exit.png"));
            menuitem.setMnemonic('Q');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.addActionListener(e -> this.close());
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            menu.add(menuitem);
            menu = new JMenu("Annotations");
            result.add(menu);
            menu.setMnemonic('A');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem((Action)this.m_ActionNewAnnotations);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionOpenAnnotations);
            menu.add(menuitem);
            this.m_MenuItemAnnotationsOpen = menuitem;
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentAnnotationsHandler = new RecentFilesHandler(ANNOTATION_SESSION_FILE, 5, (Object)submenu);
            this.m_RecentAnnotationsHandler.setAddShortcuts(false);
            this.m_RecentAnnotationsHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AudioAnnotatorPanel.this.openAnnotations(new PlaceholderFile((File)e.getItem()));
                }
            });
            this.m_MenuAnnotationLoadRecentAnnotations = submenu;
            menuitem = new JMenuItem((Action)this.m_ActionSaveAnnotations);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionExportAnnotations);
            menu.add(menuitem);
            menu = new JMenu("Shortcuts");
            result.add(menu);
            menu.setMnemonic('H');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem((Action)this.m_ActionNewBindings);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionLoadBindings);
            menu.add(menuitem);
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentBindingsHandler = new RecentFilesHandler(BINDINGS_SESSION_FILE, 5, (Object)submenu);
            this.m_RecentBindingsHandler.setAddShortcuts(false);
            this.m_RecentBindingsHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AudioAnnotatorPanel.this.loadBindings(((File)e.getItem()).getAbsolutePath());
                }
            });
            this.m_MenuFileLoadRecentBindings = submenu;
            menuitem = new JMenuItem((Action)this.m_ActionEditBindings);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionSaveBindings);
            menu.add(menuitem);
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        Runnable run = () -> {
            String title = this.m_TitleGenerator.generate(this.m_Player.getCurrentFile());
            this.setParentTitle(title);
        };
        SwingUtilities.invokeLater(run);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
    }

    public void cleanUp() {
        if (this.m_BindingsDialog != null) {
            this.m_BindingsDialog.dispose();
            this.m_BindingsDialog = null;
        }
        if (this.m_Player != null) {
            this.m_Player.cleanUp();
            this.m_Player = null;
        }
        if (this.m_EventQueue != null) {
            this.m_EventQueue.cleanUp();
            this.m_EventQueue = null;
        }
    }

    protected void updateBindingBar() {
        Runnable run = () -> {
            this.resetBindingBar();
            for (Binding item : this.m_Bindings) {
                AudioAnnotationPanel panel = new AudioAnnotationPanel();
                panel.configureAnnotationPanel(item, this.m_Player);
                this.m_BindingPanel.add((Component)((Object)panel));
                this.m_BindingPanel.revalidate();
                if (this.m_EventQueue != null) {
                    panel.addListener(this.m_EventQueue);
                }
                if (this.m_Ticker == null || !item.isToggleable()) continue;
                this.m_Ticker.addListener(panel);
            }
            this.invalidate();
            this.revalidate();
        };
        SwingUtilities.invokeLater(run);
    }

    protected void resetBindingBar() {
        this.m_BindingPanel.removeAll();
        this.m_Ticker.removeAll();
    }

    public void setTitle(String value) {
        this.m_TitleGenerator.setTitle(value);
    }

    protected void close() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
        this.cleanUp();
        this.closeParent();
    }

    public void newBindings() {
        this.m_Bindings = new ArrayList<Binding>();
        this.updateBindingBar();
    }

    public void editBindings() {
        this.m_BindingsDialog = this.getParentDialog() != null ? new EditBindingsDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new EditBindingsDialog(this.getParentFrame(), true);
        this.m_BindingsDialog.setBindings(this.m_Bindings);
        this.m_BindingsDialog.setLocationRelativeTo((Component)((Object)this));
        this.m_BindingsDialog.setVisible(true);
        if (this.m_BindingsDialog.getOption() == 2) {
            return;
        }
        this.m_Bindings = this.m_BindingsDialog.getBindings();
        this.updateBindingBar();
    }

    public void export() {
        if (this.m_EventQueue == null) {
            return;
        }
        int retVal = this.m_ExportFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        SpreadSheet sheet = this.m_EventQueue.toSpreadSheet();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_ExportFileChooser.getWriter();
        if (!writer.write(sheet, this.m_ExportFileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to export data to: " + this.m_ExportFileChooser.getSelectedFile()));
        }
    }

    public void loadBindings() {
        int retVal = this.m_LoadPropertiesFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        String bindingPath = this.m_LoadPropertiesFileChooser.getSelectedFile().getAbsolutePath();
        this.loadBindings(bindingPath);
    }

    protected void saveAnnotations() {
        int retVal = this.m_AnnotationsFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_AnnotationsFileChooser.getSelectedPlaceholderFile();
        AudioAnnotations annotations = this.m_EventQueue.getAnnotations();
        AbstractDataContainerWriter writer = (AbstractDataContainerWriter)this.m_AnnotationsFileChooser.getWriter();
        writer.setOutput(file);
        if (!writer.write((DataContainer)annotations)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write trail to '" + file + "'!\nCheck console for error message."));
        }
    }

    protected void openAnnotations() {
        int retVal = this.m_AnnotationsFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.openAnnotations(this.m_AnnotationsFileChooser.getSelectedPlaceholderFile());
    }

    protected void openAnnotations(PlaceholderFile file) {
        AbstractAudioAnnotationsReader reader = (AbstractAudioAnnotationsReader)this.m_AnnotationsFileChooser.getReaderForFile((File)file);
        reader.setInput(file);
        List readTrail = reader.read();
        if (readTrail.size() == 0) {
            return;
        }
        this.m_EventQueue.loadAnnotations((AudioAnnotations)((Object)readTrail.get(0)));
        this.m_RecentAnnotationsHandler.addRecentItem((Object)file);
    }

    public void loadBindings(String bindingPath) {
        Properties props = new Properties();
        props.load(bindingPath);
        this.m_Bindings = new ArrayList<Binding>();
        int count = props.getInteger("Count");
        for (int i = 0; i < count; ++i) {
            try {
                String prefix = Integer.toString(i);
                Properties subset = props.subset(prefix);
                Binding b = new Binding(subset, prefix);
                this.m_Bindings.add(b);
                continue;
            }
            catch (InvalidKeyException e) {
                System.err.println(e.getMessage());
            }
        }
        this.updateBindingBar();
        if (this.m_RecentBindingsHandler != null) {
            this.m_RecentBindingsHandler.addRecentItem((Object)new File(bindingPath));
        }
    }

    public void saveBindings() {
        int i;
        Properties props = new Properties();
        int retVal = this.m_SavePropertiesFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (i = 0; i < this.m_Bindings.size(); ++i) {
            props.add(this.m_Bindings.get(i).toProperty(i));
        }
        props.setInteger("Count", Integer.valueOf(i));
        String savePath = this.m_SavePropertiesFileChooser.getSelectedFile().getAbsolutePath();
        props.save(savePath);
        if (this.m_RecentBindingsHandler != null) {
            this.m_RecentBindingsHandler.addRecentItem((Object)new File(savePath));
        }
    }
}

