/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.audioannotator;

import adams.core.Properties;
import adams.gui.core.GUIHelper;
import java.security.InvalidKeyException;
import javax.swing.KeyStroke;

public class Binding {
    public static final long DEFAULT_INTERVAL = 0L;
    protected String m_Name;
    protected KeyStroke m_Binding;
    protected boolean m_Toggleable;
    protected boolean m_Inverted;
    protected long m_Interval;

    public Binding(Properties props, String prefix) throws InvalidKeyException {
        this(props.getProperty(prefix + ".Name"), GUIHelper.getKeyStroke((String)props.getProperty(prefix + ".Binding")), (boolean)props.getBoolean(prefix + ".Toggleable"), (long)props.getLong(prefix + ".Interval"), (boolean)props.getBoolean(prefix + ".Inverted"));
    }

    public Binding(String name, String binding, boolean toggle, long interval, boolean inverted) throws InvalidKeyException {
        this(name, GUIHelper.getKeyStroke((String)binding.toUpperCase()), toggle, interval, inverted);
    }

    public Binding(String name, KeyStroke binding, boolean toggle, long interval, boolean inverted) throws InvalidKeyException {
        if (binding == null) {
            throw new InvalidKeyException("Key entered is not valid");
        }
        this.m_Name = name;
        this.m_Binding = binding;
        this.m_Toggleable = toggle;
        this.m_Inverted = inverted;
        this.m_Interval = interval;
    }

    public String getName() {
        return this.m_Name;
    }

    public KeyStroke getBinding() {
        return this.m_Binding;
    }

    public boolean isToggleable() {
        return this.m_Toggleable;
    }

    public boolean isInverted() {
        return this.m_Inverted;
    }

    public Properties toProperty(int prefix) {
        Properties props = new Properties();
        props.setProperty(prefix + ".Name", this.m_Name);
        props.setProperty(prefix + ".Binding", this.m_Binding.toString());
        props.setBoolean(prefix + ".Toggleable", Boolean.valueOf(this.m_Toggleable));
        props.setBoolean(prefix + ".Inverted", Boolean.valueOf(this.m_Inverted));
        props.setLong(prefix + ".Interval", Long.valueOf(this.m_Interval));
        return props;
    }

    public String toString() {
        return "Name: " + this.m_Name + " Binding: " + this.m_Binding.toString() + " Toggleable: " + this.m_Toggleable;
    }

    public long getInterval() {
        return this.m_Interval;
    }
}

