/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.audioannotator;

import adams.data.audioannotations.AudioAnnotation;
import adams.data.audioannotations.AudioAnnotations;
import adams.data.container.DataPoint;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.RunnableWithLogging;
import adams.gui.tools.audioannotator.AnnotationEvent;
import adams.gui.tools.audioannotator.AnnotationListener;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventQueue
implements AnnotationListener {
    public static final long SLEEP_TIME = 4000L;
    protected ConcurrentLinkedQueue<AudioAnnotation> m_AnnotationQueue;
    protected AudioAnnotations m_Annotations = new AudioAnnotations();
    protected RunnableWithLogging m_Runnable;
    protected boolean m_Playing = false;

    public EventQueue() {
        this.m_AnnotationQueue = new ConcurrentLinkedQueue();
        this.start();
    }

    public void resetAnnotations() {
        this.clearQueue();
        this.m_Annotations = new AudioAnnotations();
    }

    public AudioAnnotations getAnnotations() {
        return this.m_Annotations;
    }

    public void loadAnnotations(AudioAnnotations annotations) {
        this.m_Annotations = annotations;
        this.clearQueue();
    }

    protected void clearQueue() {
        this.m_AnnotationQueue.clear();
    }

    protected void start() {
        this.m_Runnable = new RunnableWithLogging(){

            protected void doRun() {
                while (!this.m_Stopped) {
                    if (EventQueue.this.m_AnnotationQueue.peek() == null) {
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    AudioAnnotation step = EventQueue.this.m_AnnotationQueue.poll();
                    AudioAnnotation oldStep = EventQueue.this.m_Annotations.getStep(step.getTimestamp());
                    if (oldStep != null && oldStep.hasMetaData()) {
                        step.getMetaData().putAll(oldStep.getMetaData());
                    }
                    EventQueue.this.m_Annotations.add((DataPoint)step);
                }
            }
        };
        Thread t = new Thread((Runnable)this.m_Runnable);
        t.start();
    }

    public SpreadSheet toSpreadSheet() {
        return this.m_Annotations.toSpreadSheet();
    }

    @Override
    public void annotationOccurred(AnnotationEvent e) {
        this.m_AnnotationQueue.add(e.getAnnotation());
    }

    public void cleanUp() {
        this.m_Runnable.stopExecution();
    }
}

