/*
 * Decompiled with CFR 0.152.
 */
package adams.data.audio;

import adams.core.License;
import adams.core.annotation.ThirdPartyCopyright;
import gnu.trove.list.TFloatList;
import javax.sound.sampled.AudioFormat;

@ThirdPartyCopyright(license=License.CC_BY_SA_3, author="Radiodef", url="https://stackoverflow.com/a/26824664/4698227")
public class SimpleAudioConversion {
    private static final double MU = 255.0;
    private static final double A = 87.7;
    private static final double RE_A = 0.011402508551881414;
    private static final double LN_A = Math.log(87.7);
    private static final double EXP_0 = 1.0 / (1.0 + LN_A);

    private SimpleAudioConversion() {
    }

    public static int unpack(byte[] bytes, TFloatList samples, int blen, AudioFormat fmt) {
        int bitsPerSample = fmt.getSampleSizeInBits();
        int bytesPerSample = SimpleAudioConversion.bytesPerSample(bitsPerSample);
        boolean isBigEndian = fmt.isBigEndian();
        AudioFormat.Encoding encoding = fmt.getEncoding();
        double fullScale = SimpleAudioConversion.fullScale(bitsPerSample);
        int i = 0;
        int s = 0;
        while (i < blen) {
            long temp = SimpleAudioConversion.unpackBits(bytes, i, isBigEndian, bytesPerSample);
            float sample = 0.0f;
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                temp = SimpleAudioConversion.extendSign(temp, bitsPerSample);
                sample = (float)((double)temp / fullScale);
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                temp = SimpleAudioConversion.signUnsigned(temp, bitsPerSample);
                sample = (float)((double)temp / fullScale);
            } else if (encoding == AudioFormat.Encoding.PCM_FLOAT) {
                if (bitsPerSample == 32) {
                    sample = Float.intBitsToFloat((int)temp);
                } else if (bitsPerSample == 64) {
                    sample = (float)Double.longBitsToDouble(temp);
                }
            } else if (encoding == AudioFormat.Encoding.ULAW) {
                sample = SimpleAudioConversion.bitsToMuLaw(temp);
            } else if (encoding == AudioFormat.Encoding.ALAW) {
                sample = SimpleAudioConversion.bitsToALaw(temp);
            }
            samples.add(sample);
            i += bytesPerSample;
            ++s;
        }
        return s;
    }

    public static int pack(float[] samples, byte[] bytes, int slen, AudioFormat fmt) {
        int bitsPerSample = fmt.getSampleSizeInBits();
        int bytesPerSample = SimpleAudioConversion.bytesPerSample(bitsPerSample);
        boolean isBigEndian = fmt.isBigEndian();
        AudioFormat.Encoding encoding = fmt.getEncoding();
        double fullScale = SimpleAudioConversion.fullScale(bitsPerSample);
        int i = 0;
        for (int s = 0; s < slen; ++s) {
            float sample = samples[s];
            long temp = 0L;
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                temp = (long)((double)sample * fullScale);
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                temp = (long)((double)sample * fullScale);
                temp = SimpleAudioConversion.unsignSigned(temp, bitsPerSample);
            } else if (encoding == AudioFormat.Encoding.PCM_FLOAT) {
                if (bitsPerSample == 32) {
                    temp = Float.floatToRawIntBits(sample);
                } else if (bitsPerSample == 64) {
                    temp = Double.doubleToRawLongBits(sample);
                }
            } else if (encoding == AudioFormat.Encoding.ULAW) {
                temp = SimpleAudioConversion.muLawToBits(sample);
            } else if (encoding == AudioFormat.Encoding.ALAW) {
                temp = SimpleAudioConversion.aLawToBits(sample);
            }
            SimpleAudioConversion.packBits(bytes, i, temp, isBigEndian, bytesPerSample);
            i += bytesPerSample;
        }
        return i;
    }

    public static int bytesPerSample(int bitsPerSample) {
        return (int)Math.ceil((double)bitsPerSample / 8.0);
    }

    public static double fullScale(int bitsPerSample) {
        return Math.pow(2.0, bitsPerSample - 1);
    }

    private static long unpackBits(byte[] bytes, int i, boolean isBigEndian, int bytesPerSample) {
        switch (bytesPerSample) {
            case 1: {
                return SimpleAudioConversion.unpack8Bit(bytes, i);
            }
            case 2: {
                return SimpleAudioConversion.unpack16Bit(bytes, i, isBigEndian);
            }
            case 3: {
                return SimpleAudioConversion.unpack24Bit(bytes, i, isBigEndian);
            }
        }
        return SimpleAudioConversion.unpackAnyBit(bytes, i, isBigEndian, bytesPerSample);
    }

    private static long unpack8Bit(byte[] bytes, int i) {
        return (long)bytes[i] & 0xFFL;
    }

    private static long unpack16Bit(byte[] bytes, int i, boolean isBigEndian) {
        if (isBigEndian) {
            return ((long)bytes[i] & 0xFFL) << 8 | (long)bytes[i + 1] & 0xFFL;
        }
        return (long)bytes[i] & 0xFFL | ((long)bytes[i + 1] & 0xFFL) << 8;
    }

    private static long unpack24Bit(byte[] bytes, int i, boolean isBigEndian) {
        if (isBigEndian) {
            return ((long)bytes[i] & 0xFFL) << 16 | ((long)bytes[i + 1] & 0xFFL) << 8 | (long)bytes[i + 2] & 0xFFL;
        }
        return (long)bytes[i] & 0xFFL | ((long)bytes[i + 1] & 0xFFL) << 8 | ((long)bytes[i + 2] & 0xFFL) << 16;
    }

    private static long unpackAnyBit(byte[] bytes, int i, boolean isBigEndian, int bytesPerSample) {
        long temp = 0L;
        if (isBigEndian) {
            for (int b = 0; b < bytesPerSample; ++b) {
                temp |= ((long)bytes[i + b] & 0xFFL) << (int)(8L * ((long)(bytesPerSample - b) - 1L));
            }
        } else {
            for (int b = 0; b < bytesPerSample; ++b) {
                temp |= ((long)bytes[i + b] & 0xFFL) << (int)(8L * (long)b);
            }
        }
        return temp;
    }

    private static void packBits(byte[] bytes, int i, long temp, boolean isBigEndian, int bytesPerSample) {
        switch (bytesPerSample) {
            case 1: {
                SimpleAudioConversion.pack8Bit(bytes, i, temp);
                break;
            }
            case 2: {
                SimpleAudioConversion.pack16Bit(bytes, i, temp, isBigEndian);
                break;
            }
            case 3: {
                SimpleAudioConversion.pack24Bit(bytes, i, temp, isBigEndian);
                break;
            }
            default: {
                SimpleAudioConversion.packAnyBit(bytes, i, temp, isBigEndian, bytesPerSample);
            }
        }
    }

    private static void pack8Bit(byte[] bytes, int i, long temp) {
        bytes[i] = (byte)(temp & 0xFFL);
    }

    private static void pack16Bit(byte[] bytes, int i, long temp, boolean isBigEndian) {
        if (isBigEndian) {
            bytes[i] = (byte)(temp >>> 8 & 0xFFL);
            bytes[i + 1] = (byte)(temp & 0xFFL);
        } else {
            bytes[i] = (byte)(temp & 0xFFL);
            bytes[i + 1] = (byte)(temp >>> 8 & 0xFFL);
        }
    }

    private static void pack24Bit(byte[] bytes, int i, long temp, boolean isBigEndian) {
        if (isBigEndian) {
            bytes[i] = (byte)(temp >>> 16 & 0xFFL);
            bytes[i + 1] = (byte)(temp >>> 8 & 0xFFL);
            bytes[i + 2] = (byte)(temp & 0xFFL);
        } else {
            bytes[i] = (byte)(temp & 0xFFL);
            bytes[i + 1] = (byte)(temp >>> 8 & 0xFFL);
            bytes[i + 2] = (byte)(temp >>> 16 & 0xFFL);
        }
    }

    private static void packAnyBit(byte[] bytes, int i, long temp, boolean isBigEndian, int bytesPerSample) {
        if (isBigEndian) {
            for (int b = 0; b < bytesPerSample; ++b) {
                bytes[i + b] = (byte)(temp >>> (int)(8L * ((long)(bytesPerSample - b) - 1L)) & 0xFFL);
            }
        } else {
            for (int b = 0; b < bytesPerSample; ++b) {
                bytes[i + b] = (byte)(temp >>> (int)(8L * (long)b) & 0xFFL);
            }
        }
    }

    private static long extendSign(long temp, int bitsPerSample) {
        int extensionBits = 64 - bitsPerSample;
        return temp << extensionBits >> extensionBits;
    }

    private static long signUnsigned(long temp, int bitsPerSample) {
        return temp - (long)SimpleAudioConversion.fullScale(bitsPerSample);
    }

    private static long unsignSigned(long temp, int bitsPerSample) {
        return temp + (long)SimpleAudioConversion.fullScale(bitsPerSample);
    }

    private static float bitsToMuLaw(long temp) {
        if (((temp ^= 0xFFL) & 0x80L) == 128L) {
            temp = -(temp ^ 0x80L);
        }
        float sample = (float)((double)temp / SimpleAudioConversion.fullScale(8));
        return (float)((double)Math.signum(sample) * 0.00392156862745098 * (Math.pow(256.0, Math.abs(sample)) - 1.0));
    }

    private static long muLawToBits(float sample) {
        double sign = Math.signum(sample);
        sample = Math.abs(sample);
        long temp = (long)((double)(sample = (float)(sign * (Math.log(1.0 + 255.0 * (double)sample) / Math.log(256.0)))) * SimpleAudioConversion.fullScale(8));
        if (temp < 0L) {
            temp = -temp ^ 0x80L;
        }
        return temp ^ 0xFFL;
    }

    private static float bitsToALaw(long temp) {
        if (((temp ^= 0x55L) & 0x80L) == 128L) {
            temp = -(temp ^ 0x80L);
        }
        float sample = (float)((double)temp / SimpleAudioConversion.fullScale(8));
        float sign = Math.signum(sample);
        sample = (double)(sample = Math.abs(sample)) < EXP_0 ? (float)((double)sample * ((1.0 + LN_A) / 87.7)) : (float)(Math.exp((double)sample * (1.0 + LN_A) - 1.0) / 87.7);
        return sign * sample;
    }

    private static long aLawToBits(float sample) {
        double sign = Math.signum(sample);
        sample = (double)(sample = Math.abs(sample)) < 0.011402508551881414 ? (float)(87.7 * (double)sample / (1.0 + LN_A)) : (float)((1.0 + Math.log(87.7 * (double)sample)) / (1.0 + LN_A));
        long temp = (long)((double)(sample = (float)((double)sample * sign)) * SimpleAudioConversion.fullScale(8));
        if (temp < 0L) {
            temp = -temp ^ 0x80L;
        }
        return temp ^ 0x55L;
    }
}

