/*
 * Decompiled with CFR 0.152.
 */
package adams.data.audiofeaturegenerator.wave;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.OptionHandler;
import adams.data.audio.WaveContainer;
import adams.data.audiofeaturegenerator.wave.AbstractWaveFeatureGenerator;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import com.musicg.wave.Wave;
import java.util.ArrayList;
import java.util.List;

public class Spectrogram
extends AbstractWaveFeatureGenerator
implements QuickInfoSupporter {
    private static final long serialVersionUID = 1096079057750734103L;
    protected int m_FFTSampleSize;
    protected int m_OverlapFactor;
    protected boolean m_Normalized;

    public String globalInfo() {
        return "Generates a spectrogram from the audio data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("fft-sample-size", "FFTSampleSize", (Object)1024, (Number)2, null);
        this.m_OptionManager.add("overlap-factor", "overlapFactor", (Object)0, (Number)0, null);
        this.m_OptionManager.add("normalized", "normalized", (Object)false);
    }

    public void setFFTSampleSize(int value) {
        if (this.getOptionManager().isValid("FFTSampleSize", (Number)value) && Integer.bitCount(value) == 1) {
            this.m_FFTSampleSize = value;
            this.reset();
        }
    }

    public int getFFTSampleSize() {
        return this.m_FFTSampleSize;
    }

    public String FFTSampleSizeTipText() {
        return "The sample size for the fast fourier transformation; must be a power of 2.";
    }

    public void setOverlapFactor(int value) {
        if (this.getOptionManager().isValid("overlapFactor", (Number)value)) {
            this.m_OverlapFactor = value;
            this.reset();
        }
    }

    public int getOverlapFactor() {
        return this.m_OverlapFactor;
    }

    public String overlapFactorTipText() {
        return "The overlap factor (1/factor), eg 4 = 1/4 = 25%; 0 = no overlap.";
    }

    public void setNormalized(boolean value) {
        this.m_Normalized = value;
        this.reset();
    }

    public boolean getNormalized() {
        return this.m_Normalized;
    }

    public String normalizedTipText() {
        return "If enabled, the normalized spectrogram is returned rather than the absolute one.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"FFTSampleSize", (Object)this.m_FFTSampleSize, (String)"sample size: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlapFactor", (Object)(this.m_OverlapFactor == 0 ? "-none-" : "1/" + this.m_OverlapFactor), (String)", overlap factor: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"normalized", (Object)(this.m_Normalized ? "normalized" : "absolute"), (String)", ");
        return result;
    }

    @Override
    public HeaderDefinition createHeader(WaveContainer cont) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Frame", DataType.NUMERIC);
        result.add("Timestamp (seconds)", DataType.NUMERIC);
        for (int i = 0; i < this.m_FFTSampleSize / 4; ++i) {
            result.add("SPG-" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(WaveContainer cont) {
        com.musicg.wave.extension.Spectrogram sp = new com.musicg.wave.extension.Spectrogram((Wave)cont.getAudio(), this.m_FFTSampleSize, this.m_OverlapFactor);
        List[] result = new List[sp.getNumFrames()];
        double[][] data = this.m_Normalized ? sp.getNormalizedSpectrogramData() : sp.getAbsoluteSpectrogramData();
        for (int i = 0; i < sp.getNumFrames(); ++i) {
            result[i] = new ArrayList();
            result[i].add(Double.valueOf(i));
            result[i].add((double)i * 2.0 / sp.getUnitFrequency());
            for (int n = 0; n < data[i].length; ++n) {
                result[i].add(data[i][n]);
            }
        }
        return result;
    }
}

