/*
 * Decompiled with CFR 0.152.
 */
package adams.data.wavefilter;

import adams.data.audio.WaveContainer;
import adams.data.wavefilter.AbstractWaveFilter;

public class MultiFilter
extends AbstractWaveFilter {
    private static final long serialVersionUID = 2319957467336388607L;
    protected AbstractWaveFilter[] m_Filters;

    public String globalInfo() {
        return "Applies the filters sequentially, with the output data of one filter being the input data for the next.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filters", (Object)new AbstractWaveFilter[0]);
    }

    public void setFilters(AbstractWaveFilter[] value) {
        this.m_Filters = value;
        this.reset();
    }

    public AbstractWaveFilter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The filters to apply sequentially.";
    }

    @Override
    protected WaveContainer processData(WaveContainer data) {
        WaveContainer result = data;
        for (int i = 0; i < this.m_Filters.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Applying filter #" + (i + 1) + "...");
            }
            result = this.m_Filters[i].filter(result);
        }
        return result;
    }
}

