/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractSink;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class AudioPlayback
extends AbstractSink
implements LineListener {
    private static final long serialVersionUID = -1056104741820669736L;
    protected double m_Start;
    protected boolean m_PlaybackFinished;

    public String globalInfo() {
        return "Plays back an audio file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", (Object)0.0, (Number)0.0, null);
    }

    public void setStart(double value) {
        if (this.getOptionManager().isValid("start", (Number)value)) {
            this.m_Start = value;
            this.reset();
        }
    }

    public double getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The starting position for the playback in seconds.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"start", (Object)this.m_Start, (String)"start: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        PlaceholderFile file = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        Line clip = null;
        this.m_PlaybackFinished = false;
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(file.getAbsoluteFile());
            AudioFormat format = ais.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            clip = (Clip)AudioSystem.getLine(info);
            clip.addLineListener(this);
            clip.open(ais);
            clip.start();
            while (!this.isStopped() && !this.m_PlaybackFinished) {
                Utils.wait((LoggingSupporter)this, (int)1000, (int)100);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to playback file: " + file, e);
        }
        finally {
            if (clip != null) {
                clip.removeLineListener(this);
                clip.close();
            }
        }
        return result;
    }

    @Override
    public void update(LineEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Line event: " + event.getType());
        }
        if (event.getType() == LineEvent.Type.STOP) {
            this.m_PlaybackFinished = true;
        }
    }
}

