/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.audiorecorder;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.StoppableWithFeedback;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public abstract class AbstractAudioRecorder<T>
extends AbstractOptionHandler
implements QuickInfoSupporter,
FlowContextHandler,
StoppableWithFeedback {
    private static final long serialVersionUID = -5670995444597510384L;
    protected float m_SampleRate;
    protected int m_Bits;
    protected int m_Channels;
    protected boolean m_Signed;
    protected boolean m_BigEndian;
    protected Actor m_FlowContext;
    protected boolean m_Stopped;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sample-rate", "sampleRate", (Object)Float.valueOf(44100.0f), (Number)Float.valueOf(1.0f), null);
        this.m_OptionManager.add("bits", "bits", (Object)16, (Number)1, null);
        this.m_OptionManager.add("channels", "channels", (Object)1, (Number)1, null);
        this.m_OptionManager.add("signed", "signed", (Object)true);
        this.m_OptionManager.add("big-endian", "bigEndian", (Object)true);
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    public abstract boolean requiresFlowContext();

    protected String check() {
        if (this.requiresFlowContext() && this.m_FlowContext == null) {
            return "No flow context set!";
        }
        return null;
    }

    public void setSampleRate(float value) {
        if (this.getOptionManager().isValid("sampleRate", (Number)Float.valueOf(value))) {
            this.m_SampleRate = value;
            this.reset();
        }
    }

    public float getSampleRate() {
        return this.m_SampleRate;
    }

    public String sampleRateTipText() {
        return "The sample rate (hertz) to use when recording.";
    }

    public void setBits(int value) {
        if (this.getOptionManager().isValid("bits", (Number)value)) {
            this.m_Bits = value;
            this.reset();
        }
    }

    public int getBits() {
        return this.m_Bits;
    }

    public String bitsTipText() {
        return "The sample size in bits.";
    }

    public void setChannels(int value) {
        if (this.getOptionManager().isValid("channels", (Number)value)) {
            this.m_Channels = value;
            this.reset();
        }
    }

    public int getChannels() {
        return this.m_Channels;
    }

    public String channelsTipText() {
        return "The number of channels to record.";
    }

    public void setSigned(boolean value) {
        this.m_Signed = value;
        this.reset();
    }

    public boolean getSigned() {
        return this.m_Signed;
    }

    public String signedTipText() {
        return "Whether to record signed/unsigned data.";
    }

    public void setBigEndian(boolean value) {
        this.m_BigEndian = value;
        this.reset();
    }

    public boolean getBigEndian() {
        return this.m_BigEndian;
    }

    public String bigEndianTipText() {
        return "Whether to use big or little endian.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"sampleRate", (Object)Float.valueOf(this.m_SampleRate), (String)"rate: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"bits", (Object)this.m_Bits, (String)", bits: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"channels", (Object)this.m_Channels, (String)", channels: ");
        return result;
    }

    public abstract Class generates();

    protected AudioFormat getAudioFormat() {
        return new AudioFormat(this.m_SampleRate, this.m_Bits, this.m_Channels, this.m_Signed, this.m_BigEndian);
    }

    protected DataLine.Info getDataLineInfo(AudioFormat format, MessageCollection errors) {
        DataLine.Info result = new DataLine.Info(TargetDataLine.class, format);
        if (!AudioSystem.isLineSupported(result)) {
            errors.add("Line is not supported!");
        }
        return result;
    }

    protected abstract T doRecord();

    public T record() {
        this.m_Stopped = false;
        String msg = this.check();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doRecord();
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }
}

