/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.audiorecorder;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.flow.core.RunnableWithLogging;
import adams.flow.source.audiorecorder.AbstractFileBasedAudioRecorder;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;

public class FixedDuration
extends AbstractFileBasedAudioRecorder {
    private static final long serialVersionUID = 8545013784919517494L;
    protected int m_Duration;
    protected RunnableWithLogging m_Recording;
    protected RunnableWithLogging m_Monitor;

    public String globalInfo() {
        return "Records a WAV file of fixed duration. The WAV file name is used as output.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("duration", "duration", (Object)1, (Number)1, null);
    }

    @Override
    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile("${TMP}/out.wav");
    }

    @Override
    public String outputFileTipText() {
        return "The WAV file to record the audio data to.";
    }

    public void setDuration(int value) {
        if (this.getOptionManager().isValid("duration", (Number)value)) {
            this.m_Duration = value;
            this.reset();
        }
    }

    public int getDuration() {
        return this.m_Duration;
    }

    public String durationTipText() {
        return "The duration to record in seconds.";
    }

    @Override
    public boolean requiresFlowContext() {
        return false;
    }

    protected RunnableWithLogging getRecordingWorker(DataLine.Info info, AudioFormat format) {
        return this.getRecordingWorker(info, format, AudioFileFormat.Type.WAVE);
    }

    @Override
    protected String doRecordTo(PlaceholderFile output) {
        MessageCollection errors = new MessageCollection();
        final AudioFormat format = this.getAudioFormat();
        final DataLine.Info info = this.getDataLineInfo(format, errors);
        if (!errors.isEmpty()) {
            return errors.toString();
        }
        this.m_Monitor = new RunnableWithLogging(){

            protected void doRun() {
                long start = 0L;
                while (!this.isStopped()) {
                    long current;
                    if (FixedDuration.this.m_Recording == null) {
                        FixedDuration.this.m_Recording = FixedDuration.this.getRecordingWorker(info, format);
                        start = System.currentTimeMillis();
                        new Thread((Runnable)FixedDuration.this.m_Recording).start();
                    }
                    if (((current = System.currentTimeMillis()) - start) / 1000L < (long)FixedDuration.this.m_Duration || this.isStopped()) continue;
                    FixedDuration.this.m_Recording.stopExecution();
                    FixedDuration.this.m_Recording = null;
                    break;
                }
                FixedDuration.this.m_Monitor = null;
            }

            public void stopExecution() {
                if (FixedDuration.this.m_Recording != null) {
                    FixedDuration.this.m_Recording.stopExecution();
                }
                super.stopExecution();
            }
        };
        new Thread((Runnable)this.m_Monitor).start();
        while (!this.isStopped() && this.m_Monitor != null) {
            Utils.wait((LoggingSupporter)this, (int)1000, (int)100);
        }
        return null;
    }

    @Override
    public void stopExecution() {
        if (this.m_Monitor != null) {
            this.m_Monitor.stopExecution();
        }
        super.stopExecution();
    }
}

