/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.audiodata.AbstractAudioDataReader;
import adams.flow.transformer.audiodata.Wave;

public class AudioData
extends AbstractTransformer {
    private static final long serialVersionUID = -3658530451429589935L;
    protected AbstractAudioDataReader m_Reader;

    public String globalInfo() {
        return "Reads audio data using the specified reader.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new Wave());
    }

    public void setReader(AbstractAudioDataReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractAudioDataReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the audio data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"reader", (Object)((Object)this.m_Reader), (String)"reader: ");
    }

    public Class[] accepts() {
        return this.m_Reader.accepts();
    }

    public Class[] generates() {
        return new Class[]{this.m_Reader.generates()};
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_OutputToken = new Token(this.m_Reader.read(this.m_InputToken.getPayload()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to read audio data from: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }
}

