/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.audioannotator;

import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.audioannotator.Binding;
import adams.gui.tools.audioannotator.KeyPressTextField;
import java.awt.Component;
import java.security.InvalidKeyException;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

public class BindingParameterPanel
extends ParameterPanel {
    private static final long serialVersionUID = -3909613160168503521L;
    private static final int DEFAULT_TIMEOUT = 250;
    protected BaseTextField m_NameField;
    protected KeyPressTextField m_BindingField;
    protected BaseCheckBox m_Toggleable;
    protected BaseCheckBox m_Inverted;
    protected JFormattedTextField m_Interval;
    protected MaskFormatter m_MaskFormat;

    protected void initGUI() {
        super.initGUI();
        try {
            this.m_MaskFormat = new MaskFormatter("U");
        }
        catch (ParseException e) {
            System.err.println("formatter is bad: " + e.getMessage());
        }
        this.m_NameField = new BaseTextField();
        this.m_BindingField = new KeyPressTextField();
        this.m_Toggleable = new BaseCheckBox();
        this.m_Inverted = new BaseCheckBox();
        this.m_Interval = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.m_Interval.setValue(250);
        this.addParameter(false, "Name", (Component)this.m_NameField);
        this.addParameter(false, "Binding", (Component)((Object)this.m_BindingField));
        this.addParameter(false, "Toggleable", (Component)this.m_Toggleable);
        this.addParameter(false, "Interval (in milliseconds)", this.m_Interval);
        this.addParameter(false, "Inverted", (Component)this.m_Inverted);
    }

    public void clearFields() {
        this.m_NameField.setText("");
        this.m_BindingField.setText("");
        this.m_Toggleable.setSelected(false);
        this.m_Inverted.setSelected(false);
        this.m_Interval.setValue(250);
    }

    public Binding getBinding() {
        long interval = ((Number)this.m_Interval.getValue()).longValue();
        try {
            Binding b = new Binding(this.m_NameField.getText(), this.m_BindingField.getLastPressed(), this.m_Toggleable.isSelected(), interval, this.m_Inverted.isSelected());
            this.clearFields();
            System.out.println("Binding in Parameter Panel " + b.toString() + " Interval " + b.getInterval());
            return b;
        }
        catch (InvalidKeyException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public void loadBinding(Binding binding) {
        this.m_NameField.setText(binding.getName());
        this.m_BindingField.setText(binding.getBinding().toString());
        this.m_BindingField.setLastPressed(binding.getBinding());
        this.m_Toggleable.setSelected(binding.isToggleable());
        this.m_Inverted.setSelected(binding.isInverted());
        this.m_Interval.setValue(binding.getInterval());
    }
}

